/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.render.IInfoRenderer;
import crazypants.enderio.power.PowerDisplayUtil;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class IoDisplay
implements IInfoRenderer {
    private float previousAverageInput;
    private float previousAverageOutput;
    String averageInputText = "0";
    String averageOutputText = "0";
    HeadingText heading1;
    HeadingText heading2;

    @Override
    public void render(TileCapBank cb, ForgeDirection dir, double x, double y, double z, float partialTick) {
        float offset;
        if (dir.offsetY != 0) {
            return;
        }
        CapBankClientNetwork nw = (CapBankClientNetwork)cb.getNetwork();
        if (nw == null) {
            return;
        }
        CapBankClientNetwork.IOInfo info = nw.getIODisplayInfo(cb.field_145851_c, cb.field_145848_d, cb.field_145849_e, dir);
        if (info.isInside()) {
            return;
        }
        boolean selfIlum = true;
        int brightness = 0;
        if (!selfIlum) {
            brightness = cb.func_145831_w().func_72802_i(cb.field_145851_c + dir.offsetX, cb.field_145848_d + dir.offsetY, cb.field_145849_e + dir.offsetZ, 0);
            int l1 = brightness % 65536;
            int l2 = brightness / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        } else {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        boolean drawBackground = true;
        if (drawBackground) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            if (!selfIlum) {
                tes.func_78380_c(brightness);
            }
            tes.func_78386_a(1.0f, 1.0f, 1.0f);
            float scale = 0.85f;
            float offset2 = (1.0f - scale) / 2.0f;
            IIcon icon = EnderIO.blockCapBank.getInfoPanelIcon();
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            switch (dir) {
                case NORTH: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float x0 = offset2;
                    float x1 = (float)info.width - offset2;
                    float z0 = 0.0f;
                    tes.func_78375_b(0.0f, 0.0f, -1.0f);
                    tes.func_78374_a((double)x1, (double)y0, (double)z0, (double)minU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    tes.func_78374_a((double)x1, (double)y1, (double)z0, (double)minU, (double)maxV);
                    break;
                }
                case SOUTH: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float x0 = offset2 - (float)(info.width - 1);
                    float x1 = 1.0f - offset2;
                    float z1 = 1.0f;
                    tes.func_78375_b(0.0f, 0.0f, 1.0f);
                    tes.func_78374_a((double)x0, (double)y0, (double)z1, (double)maxU, (double)minV);
                    tes.func_78374_a((double)x1, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.func_78374_a((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z1, (double)maxU, (double)maxV);
                    break;
                }
                case EAST: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float z0 = offset2;
                    float z1 = (float)info.width - offset2;
                    float x1 = 1.0f;
                    tes.func_78375_b(1.0f, 0.0f, 0.0f);
                    tes.func_78374_a((double)x1, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    tes.func_78374_a((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.func_78374_a((double)x1, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.func_78374_a((double)x1, (double)y0, (double)z0, (double)maxU, (double)minV);
                    break;
                }
                case WEST: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float z0 = offset2 - (float)(info.width - 1);
                    float z1 = 1.0f - offset2;
                    float x0 = 0.0f;
                    tes.func_78375_b(-1.0f, 0.0f, 0.0f);
                    tes.func_78374_a((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            tes.func_78381_a();
        }
        nw.requestPowerUpdate(cb, 20);
        this.heading1 = HeadingText.STABLE;
        this.heading2 = null;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float size = 0.15f * (float)Math.min(info.width, info.height);
        float scale = size / (float)fr.field_78288_b;
        if (info.height * 3 >= info.width * 4) {
            this.heading1 = HeadingText.INPUT;
            this.heading2 = HeadingText.OUTPUT;
            if (this.previousAverageInput != nw.getAverageInputPerTick()) {
                this.averageInputText = this.getChangeText(nw.getAverageInputPerTick(), fr);
                this.previousAverageInput = nw.getAverageInputPerTick();
            }
            if (this.previousAverageOutput != nw.getAverageOutputPerTick()) {
                this.averageOutputText = this.getChangeText(nw.getAverageOutputPerTick(), fr);
                this.previousAverageOutput = nw.getAverageOutputPerTick();
            }
            offset = -size * 2.5f;
        } else {
            int change = Math.round(nw.getAverageChangePerTick());
            if (change > 0) {
                this.heading1 = HeadingText.GAIN;
            } else if (change < 0) {
                this.heading1 = HeadingText.LOSS;
            }
            if ((float)change != this.previousAverageInput) {
                this.averageInputText = this.getChangeText(change, fr);
                this.previousAverageInput = change;
            }
            offset = -size;
        }
        ForgeDirection right = dir.getRotation(ForgeDirection.UP);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)dir.offsetX * 1.02f / 2.0f + 0.5f + (float)(right.offsetX * (info.width - 1)) * 0.5f), (float)(1.0f + size * 0.5f - (float)info.height * 0.5f), (float)((float)dir.offsetZ * 1.02f / 2.0f + 0.5f + (float)(right.offsetZ * (info.width - 1)) * 0.5f));
        GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (dir == ForgeDirection.NORTH) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.EAST) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.WEST) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        offset = this.drawText(this.heading1, this.averageInputText, offset, scale, size, fr);
        if (this.heading2 != null) {
            this.drawText(this.heading2, this.averageOutputText, offset, scale, size, fr);
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private float drawText(HeadingText heading, String text, float offset, float scale, float size, FontRenderer fr) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)offset, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(heading.text, -fr.func_78256_a(heading.text) / 2, 0, 0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(offset += size * 1.5f), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(text, -fr.func_78256_a(text) / 2, 0, heading.color);
        GL11.glPopMatrix();
        return offset += size * 1.5f;
    }

    protected String getChangeText(float average, FontRenderer fr) {
        int change = Math.round(Math.abs(average));
        String txt = PowerDisplayUtil.INT_NF.format(change);
        int width = fr.func_78256_a(txt);
        if (width > 38 && change > 1000) {
            txt = PowerDisplayUtil.INT_NF.format(change /= 1000) + "K";
        }
        return txt;
    }

    static enum HeadingText {
        STABLE(ColorUtil.getRGB((int)0, (int)0, (int)0)),
        GAIN(ColorUtil.getRGB((float)0.0f, (float)0.25f, (float)0.0f)),
        LOSS(ColorUtil.getRGB((float)0.25f, (float)0.0f, (float)0.0f)),
        INPUT(ColorUtil.getRGB((float)0.0f, (float)0.25f, (float)0.0f)),
        OUTPUT(ColorUtil.getRGB((float)0.25f, (float)0.0f, (float)0.0f));

        final String text = EnderIO.lang.localize("capbank.iodisplay.".concat(this.name().toLowerCase(Locale.US)));
        final int color;

        private HeadingText(int color) {
            this.color = color;
        }
    }
}

