/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import crazypants.enderio.machine.invpanel.server.SlotKey;
import net.minecraft.item.ItemStack;

abstract class AbstractInventory {
    static final SlotKey[] NO_SLOTS = new SlotKey[0];
    SlotKey[] slotKeys = NO_SLOTS;

    AbstractInventory() {
    }

    protected void setEmpty(InventoryDatabaseServer db) {
        if (this.slotKeys.length != 0) {
            this.reset(db, 0);
        }
    }

    protected void reset(InventoryDatabaseServer db, int count) {
        for (SlotKey slotKey : this.slotKeys) {
            if (slotKey == null) continue;
            slotKey.remove(db);
        }
        this.slotKeys = new SlotKey[count];
    }

    protected void updateSlot(InventoryDatabaseServer db, int slot, ItemStack stack) {
        if (stack == null) {
            this.emptySlot(db, slot);
        } else {
            this.updateSlot(db, slot, stack, stack.field_77994_a);
        }
    }

    protected void updateSlot(InventoryDatabaseServer db, int slot, ItemStack stack, int count) {
        SlotKey slotKey = this.slotKeys[slot];
        ItemEntry current = slotKey != null ? slotKey.item : null;
        ItemEntry key = db.lookupItem(stack, current, true);
        if (key != current) {
            this.updateSlotKey(db, slot, slotKey, key, count);
        } else if (slotKey != null && slotKey.count != count) {
            slotKey.count = count;
            db.entryChanged(current);
        }
    }

    protected void emptySlot(InventoryDatabaseServer db, int slot) {
        SlotKey slotKey = this.slotKeys[slot];
        if (slotKey != null) {
            slotKey.remove(db);
            this.slotKeys[slot] = null;
        }
    }

    private void updateSlotKey(InventoryDatabaseServer db, int slot, SlotKey slotKey, ItemEntry key, int count) {
        if (slotKey != null) {
            slotKey.remove(db);
            slotKey = null;
        }
        if (key != null) {
            slotKey = new SlotKey(this, slot, key, count);
            key.addSlot(slotKey);
            db.entryChanged(key);
        }
        this.slotKeys[slot] = slotKey;
    }

    protected void updateCount(InventoryDatabaseServer db, int slot, ItemEntry entry, int count) {
        SlotKey slotKey = this.slotKeys[slot];
        if (slotKey != null && slotKey.count != count && slotKey.item == entry) {
            if (count == 0) {
                slotKey.remove(db);
                this.slotKeys[slot] = null;
            } else {
                slotKey.count = count;
                db.entryChanged(slotKey.item);
            }
        }
    }

    abstract int scanInventory(InventoryDatabaseServer var1);

    abstract int extractItem(InventoryDatabaseServer var1, ItemEntry var2, int var3, int var4);
}

