/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.spawner.ContainerPoweredSpawner;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.GuiPoweredSpawner;
import crazypants.enderio.machine.spawner.ItemBrokenSpawner;
import crazypants.enderio.machine.spawner.PacketMode;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.machine.spawner.TilePoweredSpawner;
import crazypants.enderio.network.PacketHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;

public class BlockPoweredSpawner
extends AbstractMachineBlock<TilePoweredSpawner>
implements IAdvancedTooltipProvider {
    public static final String KEY_SPAWNED_BY_POWERED_SPAWNER = "spawnedByPoweredSpawner";
    private final List<GameRegistry.UniqueIdentifier> toolBlackList = new ArrayList<GameRegistry.UniqueIdentifier>();
    private Field fieldpersistenceRequired;
    private final Map<BlockCoord, ItemStack> dropCache = new HashMap<BlockCoord, ItemStack>();

    public static void writeMobTypeToNBT(NBTTagCompound nbt, String type) {
        if (nbt == null) {
            return;
        }
        if (type == null) {
            nbt.func_82580_o("mobType");
        } else {
            nbt.func_74778_a("mobType", type);
        }
    }

    public static String readMobTypeFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.func_74764_b("mobType")) {
            return null;
        }
        return nbt.func_74779_i("mobType");
    }

    public static String getSpawnerTypeFromItemStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != Item.func_150898_a((Block)EnderIO.blockPoweredSpawner)) {
            return null;
        }
        return BlockPoweredSpawner.readMobTypeFromNBT(stack.field_77990_d);
    }

    public static BlockPoweredSpawner create() {
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPoweredSpawner.unlocalisedName, new DummyRecipe());
        PacketHandler.INSTANCE.registerMessage(PacketMode.class, PacketMode.class, PacketHandler.nextID(), Side.SERVER);
        PoweredSpawnerConfig.getInstance();
        BlockPoweredSpawner res = new BlockPoweredSpawner();
        res.init();
        return res;
    }

    protected BlockPoweredSpawner() {
        super(ModObject.blockPoweredSpawner, TilePoweredSpawner.class);
        String[] blackListNames;
        for (String name : blackListNames = Config.brokenSpawnerToolBlacklist) {
            this.toolBlackList.add(new GameRegistry.UniqueIdentifier(name));
        }
        try {
            this.fieldpersistenceRequired = ReflectionHelper.findField(EntityLiving.class, (String[])new String[]{"field_82179_bU", "persistenceRequired"});
        }
        catch (Exception e) {
            Log.error("BlockPoweredSpawner: Could not find field: persistenceRequired");
        }
    }

    @Override
    protected void init() {
        super.init();
        EventHandler handler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        FMLCommonHandler.instance().bus().register((Object)handler);
    }

    public boolean isBlackListed(String entityId) {
        return PoweredSpawnerConfig.getInstance().isBlackListed(entityId);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TilePoweredSpawner) {
            return new ContainerPoweredSpawner(player.field_71071_by, (TilePoweredSpawner)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TilePoweredSpawner) {
            return new GuiPoweredSpawner(player.field_71071_by, (TilePoweredSpawner)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 88;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:poweredSpawnerFrontActive";
        }
        return "enderio:poweredSpawnerFront";
    }

    public boolean func_149662_c() {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String type = BlockPoweredSpawner.getSpawnerTypeFromItemStack(itemstack);
        if (type != null) {
            list.add(StatCollector.func_74838_a((String)("entity." + type + ".name")));
        } else {
            list.add(EnderIO.lang.localizeExact("tile.blockPoweredSpawner.tooltip.empty"));
        }
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String type = BlockPoweredSpawner.getSpawnerTypeFromItemStack(itemstack);
        if (type == null) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"tile.blockPoweredSpawner.empty");
        } else {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"tile.blockPoweredSpawner");
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TilePoweredSpawner te = (TilePoweredSpawner)world.func_147438_o(x, y, z);
        tooltip.add(te.getEntityName());
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        super.func_149666_a(item, tab, list);
        list.add(this.createItemStackForMob("Enderman"));
        list.add(this.createItemStackForMob("Chicken"));
    }

    protected ItemStack createItemStackForMob(String mob) {
        ItemStack stack = new ItemStack((Block)this);
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74757_a("eio.abstractMachine", true);
        BlockPoweredSpawner.writeMobTypeToNBT(stack.field_77990_d, mob);
        return stack;
    }

    public class EventHandler {
        @SubscribeEvent
        public void onBreakEvent(BlockEvent.BreakEvent evt) {
            if (evt.block instanceof BlockMobSpawner) {
                if (!(evt.getPlayer() == null || evt.getPlayer().field_71075_bZ.field_75098_d || evt.getPlayer().field_70170_p.field_72995_K || evt.isCanceled())) {
                    TileEntity tile = evt.getPlayer().field_70170_p.func_147438_o(evt.x, evt.y, evt.z);
                    if (tile instanceof TileEntityMobSpawner) {
                        String name;
                        TileEntityMobSpawner spawner;
                        MobSpawnerBaseLogic logic;
                        if (Math.random() > Config.brokenSpawnerDropChance) {
                            return;
                        }
                        ItemStack equipped = evt.getPlayer().func_71045_bC();
                        if (equipped != null) {
                            for (GameRegistry.UniqueIdentifier uid : BlockPoweredSpawner.this.toolBlackList) {
                                Item blackListItem = GameRegistry.findItem((String)uid.modId, (String)uid.name);
                                if (blackListItem != equipped.func_77973_b()) continue;
                                return;
                            }
                        }
                        if ((logic = (spawner = (TileEntityMobSpawner)tile).func_145881_a()) != null && (name = logic.func_98276_e()) != null && !BlockPoweredSpawner.this.isBlackListed(name)) {
                            ItemStack drop = ItemBrokenSpawner.createStackForMobType(name);
                            BlockPoweredSpawner.this.dropCache.put(new BlockCoord(evt.x, evt.y, evt.z), drop);
                            for (int i = (int)(Math.random() * 7.0); i > 0; --i) {
                                logic.field_98286_b = 0;
                                logic.func_98278_g();
                            }
                        }
                    }
                } else {
                    BlockPoweredSpawner.this.dropCache.put(new BlockCoord(evt.x, evt.y, evt.z), null);
                }
            }
        }

        @SubscribeEvent
        public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent evt) {
            if (!evt.isCanceled() && evt.block instanceof BlockMobSpawner) {
                BlockCoord bc = new BlockCoord(evt.x, evt.y, evt.z);
                if (BlockPoweredSpawner.this.dropCache.containsKey(bc)) {
                    ItemStack stack = (ItemStack)BlockPoweredSpawner.this.dropCache.get(bc);
                    if (stack != null) {
                        evt.drops.add(stack);
                    }
                } else {
                    try {
                        for (Object object : evt.world.field_147482_g) {
                            String name;
                            MobSpawnerBaseLogic logic;
                            TileEntityMobSpawner spawner;
                            if (!(object instanceof TileEntityMobSpawner) || (spawner = (TileEntityMobSpawner)object).func_145831_w() != evt.world || spawner.field_145851_c != evt.x || spawner.field_145848_d != evt.y || spawner.field_145849_e != evt.z || (logic = spawner.func_145881_a()) == null || (name = logic.func_98276_e()) == null || BlockPoweredSpawner.this.isBlackListed(name)) continue;
                            evt.drops.add(ItemBrokenSpawner.createStackForMobType(name));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                BlockPoweredSpawner.this.dropCache.clear();
            }
        }

        @SubscribeEvent
        public void handleAnvilEvent(AnvilUpdateEvent evt) {
            if (evt.left == null || evt.left.field_77994_a != 1 || evt.left.func_77973_b() != Item.func_150898_a((Block)EnderIO.blockPoweredSpawner) || evt.right == null || ItemBrokenSpawner.getMobTypeFromStack(evt.right) == null) {
                return;
            }
            String spawnerType = ItemBrokenSpawner.getMobTypeFromStack(evt.right);
            if (BlockPoweredSpawner.this.isBlackListed(spawnerType)) {
                return;
            }
            evt.cost = Config.powerSpawnerAddSpawnerCost;
            evt.output = evt.left.func_77946_l();
            if (evt.output.field_77990_d == null) {
                evt.output.field_77990_d = new NBTTagCompound();
            }
            evt.output.field_77990_d.func_74757_a("eio.abstractMachine", true);
            BlockPoweredSpawner.writeMobTypeToNBT(evt.output.field_77990_d, spawnerType);
        }

        @SubscribeEvent
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent livingUpdate) {
            EntityLivingBase ent = livingUpdate.entityLiving;
            if (!ent.getEntityData().func_74764_b(BlockPoweredSpawner.KEY_SPAWNED_BY_POWERED_SPAWNER)) {
                return;
            }
            if (BlockPoweredSpawner.this.fieldpersistenceRequired == null) {
                ent.getEntityData().func_82580_o(BlockPoweredSpawner.KEY_SPAWNED_BY_POWERED_SPAWNER);
                return;
            }
            long spawnTime = ent.getEntityData().func_74763_f(BlockPoweredSpawner.KEY_SPAWNED_BY_POWERED_SPAWNER);
            long livedFor = livingUpdate.entity.field_70170_p.func_82737_E() - spawnTime;
            if (livedFor > (long)(Config.poweredSpawnerDespawnTimeSeconds * 20)) {
                try {
                    BlockPoweredSpawner.this.fieldpersistenceRequired.setBoolean(livingUpdate.entityLiving, false);
                    ent.getEntityData().func_82580_o(BlockPoweredSpawner.KEY_SPAWNED_BY_POWERED_SPAWNER);
                }
                catch (Exception e) {
                    Log.warn("BlockPoweredSpawner.onLivingUpdate: Error occured allowing entity to despawn: " + e);
                    ent.getEntityData().func_82580_o(BlockPoweredSpawner.KEY_SPAWNED_BY_POWERED_SPAWNER);
                }
            }
        }
    }

    private static class DropInfo {
        BlockEvent.BreakEvent evt;
        ItemStack drop;

        DropInfo(BlockEvent.BreakEvent evt, ItemStack stack) {
            this.evt = evt;
            this.drop = stack;
        }

        void doDrop() {
            if (this.evt.isCanceled()) {
                return;
            }
            Util.dropItems((World)this.evt.getPlayer().field_70170_p, (ItemStack)this.drop, (int)this.evt.x, (int)this.evt.y, (int)this.evt.z, (boolean)true);
        }
    }
}

