/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class ItemBrokenSpawner
extends Item {
    private static final String[] CREATIVE_TYPES = new String[]{"Skeleton", "Zombie", "Spider", "CaveSpider", "Blaze", "Enderman", "Chicken"};

    public static String getMobTypeFromStack(ItemStack stack) {
        if (stack == null || stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("mobType")) {
            return null;
        }
        return stack.field_77990_d.func_74779_i("mobType");
    }

    public static ItemStack createStackForMobType(String mobType) {
        if (mobType == null) {
            return null;
        }
        ItemStack res = new ItemStack((Item)EnderIO.itemBrokenSpawner);
        res.field_77990_d = new NBTTagCompound();
        res.field_77990_d.func_74778_a("mobType", mobType);
        return res;
    }

    public static ItemBrokenSpawner create() {
        ItemBrokenSpawner result = new ItemBrokenSpawner();
        result.init();
        return result;
    }

    protected ItemBrokenSpawner() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemBrokenSpawner.unlocalisedName);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
    }

    public boolean func_77645_m() {
        return false;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemBrokenSpawner.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iIconRegister) {
        this.field_77791_bV = iIconRegister.func_94245_a("enderio:itemBrokenSpawner");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (String mobType : CREATIVE_TYPES) {
            par3List.add(ItemBrokenSpawner.createStackForMobType(mobType));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        if (par1ItemStack != null && par1ItemStack.field_77990_d != null) {
            String mobName = ItemBrokenSpawner.getMobTypeFromStack(par1ItemStack);
            if (mobName != null) {
                par3List.add(StatCollector.func_74838_a((String)("entity." + mobName + ".name")));
            }
            if (!SpecialTooltipHandler.showAdvancedTooltips()) {
                SpecialTooltipHandler.addShowDetailsTooltip(par3List);
            } else {
                SpecialTooltipHandler.addDetailedTooltipFromResources(par3List, (ItemStack)par1ItemStack);
            }
        }
    }
}

