/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import crazypants.enderio.Log;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import crazypants.util.EE3Util;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.NotImplementedException;

public class VatRecipe
implements IRecipe {
    protected final List<ItemStack> inputStacks;
    protected final boolean valid;
    protected final Table<RecipeInput, RecipeInput, FluidStack> inputFluidStacks = HashBasedTable.create();
    protected final Table<RecipeInput, RecipeInput, FluidStack> outputFluidStacks = HashBasedTable.create();
    protected final RecipeInput[] inputs;
    protected final RecipeOutput[] output;
    protected final int energyRequired;
    private int requiredItems;

    public VatRecipe(IRecipe recipe) {
        FluidStack inputFluidStack = null;
        FluidStack outputFluidStack = null;
        this.inputs = recipe.getInputs();
        for (RecipeOutput recipeOutput : recipe.getOutputs()) {
            if (!recipeOutput.isFluid()) continue;
            outputFluidStack = recipeOutput.getFluidOutput().copy();
            break;
        }
        if (outputFluidStack == null) {
            Log.warn("Ignoring invalid VAT recipe without output fluid");
        } else {
            this.requiredItems = 1;
            for (RecipeInput recipeInput : this.inputs) {
                if (recipeInput.isFluid() || recipeInput.getSlotNumber() != 1) continue;
                this.requiredItems = 2;
            }
            if (this.requiredItems == 2) {
                for (RecipeInput recipeInput : this.inputs) {
                    if (recipeInput.isFluid() || recipeInput.getSlotNumber() != 0) continue;
                    for (RecipeInput r1 : this.inputs) {
                        if (r1.isFluid() || r1.getSlotNumber() != 1) continue;
                        for (RecipeInput r2 : this.inputs) {
                            if (!r2.isFluid()) continue;
                            float im = recipeInput.getMulitplier() * r1.getMulitplier();
                            inputFluidStack = r2.getFluidInput().copy();
                            inputFluidStack.amount = Math.round(1000.0f * im);
                            outputFluidStack.amount = Math.round(im * r2.getMulitplier() * 1000.0f);
                            this.inputFluidStacks.put((Object)recipeInput, (Object)r1, (Object)inputFluidStack.copy());
                            this.outputFluidStacks.put((Object)recipeInput, (Object)r1, (Object)outputFluidStack.copy());
                            EE3Util.registerRecipe(outputFluidStack.copy(), recipeInput.getInput().func_77946_l(), r1.getInput().func_77946_l(), inputFluidStack.copy());
                        }
                    }
                }
            } else {
                for (RecipeInput recipeInput : this.inputs) {
                    if (recipeInput.isFluid()) continue;
                    for (RecipeInput r2 : this.inputs) {
                        if (!r2.isFluid()) continue;
                        float im = recipeInput.getMulitplier();
                        inputFluidStack = r2.getFluidInput().copy();
                        inputFluidStack.amount = Math.round(1000.0f * im);
                        outputFluidStack.amount = Math.round(im * r2.getMulitplier() * 1000.0f);
                        this.inputFluidStacks.put((Object)recipeInput, (Object)recipeInput, (Object)inputFluidStack.copy());
                        this.outputFluidStacks.put((Object)recipeInput, (Object)recipeInput, (Object)outputFluidStack.copy());
                        EE3Util.registerRecipe(outputFluidStack.copy(), recipeInput.getInput().func_77946_l(), inputFluidStack.copy());
                    }
                }
            }
            if (inputFluidStack == null) {
                Log.warn("Ignoring invalid VAT recipe without input fluid/stacks");
            }
        }
        this.output = new RecipeOutput[]{new RecipeOutput(outputFluidStack)};
        this.energyRequired = recipe.getEnergyRequired();
        this.inputStacks = recipe.getInputStacks();
        this.valid = inputFluidStack != null && this.inputStacks != null && !this.inputStacks.isEmpty() && this.inputStacks.size() > 0 && outputFluidStack != null;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    public RecipeOutput[] getOutputs() {
        return this.output;
    }

    @Override
    public RecipeInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public List<ItemStack> getInputStacks() {
        return this.inputStacks;
    }

    @Override
    public RecipeBonusType getBonusType() {
        return RecipeBonusType.NONE;
    }

    private RecipeInput getRecipeInput(int slot, ItemStack item) {
        if (item == null) {
            return null;
        }
        for (RecipeInput ri : this.inputs) {
            if (ri.getSlotNumber() != slot || !ri.isInput(item)) continue;
            return ri;
        }
        return null;
    }

    @Override
    public boolean isValidInput(int slot, ItemStack item) {
        return this.getRecipeInput(slot, item) != null;
    }

    @Override
    public boolean isValidInput(FluidStack item) {
        if (item == null) {
            return false;
        }
        for (RecipeInput ri : this.inputs) {
            if (item.getFluid() == null || !item.isFluidEqual(ri.getFluidInput())) continue;
            return true;
        }
        return false;
    }

    private RecipeMatch matchRecipe(MachineRecipeInput ... inputs) {
        if (!this.isValid() || inputs == null || inputs.length < this.requiredItems + 1) {
            return null;
        }
        FluidStack inputFluid = null;
        RecipeMatch m = new RecipeMatch();
        for (MachineRecipeInput in : inputs) {
            if (in.isFluid()) {
                inputFluid = in.fluid;
                continue;
            }
            m.setRecipeInput(this.getRecipeInput(in.slotNumber, in.item));
        }
        if (this.requiredItems == 1) {
            m.r1 = m.r0;
        }
        m.in = (FluidStack)this.inputFluidStacks.get((Object)m.r0, (Object)m.r1);
        m.out = (FluidStack)this.outputFluidStacks.get((Object)m.r0, (Object)m.r1);
        if (inputFluid != null && inputFluid.containsFluid(m.in)) {
            return m;
        }
        return null;
    }

    @Override
    public boolean isInputForRecipe(MachineRecipeInput ... inputs) {
        RecipeMatch m = this.matchRecipe(inputs);
        return m != null;
    }

    @Override
    public List<FluidStack> getInputFluidStacks() {
        throw new NotImplementedException("");
    }

    public float getMultiplierForInput(FluidStack item) {
        for (RecipeInput input : this.inputs) {
            if (!input.isInput(item)) continue;
            return input.getMulitplier();
        }
        return 1.0f;
    }

    public FluidStack getRequiredFluidInput(MachineRecipeInput[] inputs) {
        RecipeMatch m = this.matchRecipe(inputs);
        if (m != null) {
            return m.in;
        }
        return new FluidStack(FluidRegistry.WATER, 999000);
    }

    public FluidStack getFluidOutput(MachineRecipeInput ... inputs) {
        RecipeMatch m = this.matchRecipe(inputs);
        if (m != null) {
            return m.out;
        }
        return new FluidStack(FluidRegistry.WATER, 0);
    }

    public int getNumConsumed(ItemStack item) {
        for (RecipeInput input : this.inputs) {
            if (!input.isInput(item)) continue;
            return input.getInput().field_77994_a;
        }
        return 1;
    }

    private static class RecipeMatch {
        RecipeInput r0;
        RecipeInput r1;
        FluidStack in;
        FluidStack out;

        private RecipeMatch() {
        }

        void setRecipeInput(RecipeInput r) {
            if (r != null) {
                if (r.getSlotNumber() == 0) {
                    this.r0 = r;
                } else {
                    this.r1 = r;
                }
            }
        }
    }
}

