/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.common.util.OreDictionaryHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemEnderFood;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.material.BlockFusedQuartz;
import crazypants.enderio.material.MachinePart;
import crazypants.enderio.material.Material;
import crazypants.enderio.material.OreDictionaryPreferences;
import crazypants.enderio.material.PowderIngot;
import crazypants.enderio.material.endergy.AlloyEndergy;
import crazypants.enderio.power.Capacitors;
import crazypants.util.RecipeUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class MaterialRecipes {
    public static void registerDependantOresInDictionary() {
        for (PowderIngot powder : PowderIngot.values()) {
            if (!powder.hasDependancy() || !powder.isDependancyMet()) continue;
            OreDictionary.registerOre((String)powder.oreDictName, (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, powder.ordinal()));
            powder.setRegistered();
        }
    }

    public static void registerOresInDictionary() {
        boolean isPrimaryName;
        if (!EnderIO.hasGT5) {
            for (Enum enum_ : PowderIngot.values()) {
                if (((PowderIngot)enum_).hasDependancy()) continue;
                OreDictionary.registerOre((String)((PowderIngot)enum_).oreDictName, (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, enum_.ordinal()));
            }
        }
        for (Enum enum_ : Capacitors.values()) {
            OreDictionary.registerOre((String)((Capacitors)enum_).getOreTag(), (ItemStack)new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, enum_.ordinal()));
        }
        for (Enum enum_ : Alloy.values()) {
            isPrimaryName = true;
            for (String oreDictName : ((Alloy)enum_).getOreIngots()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackIngot());
                if (isPrimaryName) {
                    isPrimaryName = false;
                    continue;
                }
                RecipeUtil.addShapeless(((Alloy)enum_).getStackIngot(2), oreDictName, oreDictName);
            }
            isPrimaryName = true;
            for (String oreDictName : ((Alloy)enum_).getOreBlocks()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackBlock());
                if (isPrimaryName) {
                    isPrimaryName = false;
                    continue;
                }
                RecipeUtil.addShapeless(((Alloy)enum_).getStackBlock(2), oreDictName, oreDictName);
            }
        }
        for (Enum enum_ : AlloyEndergy.values()) {
            isPrimaryName = true;
            for (String oreDictName : ((AlloyEndergy)enum_).getOreIngots()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((AlloyEndergy)enum_).getStackIngot());
                if (isPrimaryName) {
                    isPrimaryName = false;
                    continue;
                }
                RecipeUtil.addShapeless(((AlloyEndergy)enum_).getStackIngot(2), oreDictName, oreDictName);
            }
            isPrimaryName = true;
            for (String oreDictName : ((AlloyEndergy)enum_).getOreBlocks()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((AlloyEndergy)enum_).getStackBlock());
                if (isPrimaryName) {
                    isPrimaryName = false;
                    continue;
                }
                RecipeUtil.addShapeless(((AlloyEndergy)enum_).getStackBlock(2), oreDictName, oreDictName);
            }
        }
        OreDictionary.registerOre((String)"nuggetPulsatingIron", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.PHASED_IRON_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"nuggetVibrantAlloy", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"nuggetEndSteel", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.END_STEEL_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"glass", (Block)Blocks.field_150359_w);
        OreDictionary.registerOre((String)"stickWood", (Item)Items.field_151055_y);
        OreDictionary.registerOre((String)"woodStick", (Item)Items.field_151055_y);
        OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingotIron", (Item)Items.field_151042_j);
        OreDictionary.registerOre((String)"ingotGold", (Item)Items.field_151043_k);
        ItemStack pureGlass = new ItemStack((Block)EnderIO.blockFusedQuartz, 1, BlockFusedQuartz.Type.GLASS.ordinal());
        OreDictionary.registerOre((String)"glass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack((Block)EnderIO.blockFusedQuartz, 1, BlockFusedQuartz.Type.FUSED_QUARTZ.ordinal()));
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)skull);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack((Block)EnderIO.blockEndermanSkull));
        RecipeUtil.addShaped(new ItemStack(Blocks.field_150410_aZ, 16, 0), "eee", "eee", Character.valueOf('e'), pureGlass);
        RecipeUtil.addShapeless(new ItemStack(Blocks.field_150359_w), pureGlass);
        RecipeUtil.addShaped(new ItemStack(Items.field_151069_bo, 3, 0), "g g", " g ", Character.valueOf('g'), pureGlass);
        Material.registerOres(EnderIO.itemMaterial);
        MachinePart.registerOres(EnderIO.itemMachinePart);
    }

    public static void addRecipes() {
        String prismarine;
        String ingotCopper;
        String conduitBinder = Material.CONDUIT_BINDER.oreDict;
        ItemStack fusedQuartzFrame = new ItemStack((Item)EnderIO.itemFusedQuartzFrame, 1, 0);
        String energeticAlloy = Alloy.ENERGETIC_ALLOY.getOreIngot();
        String phasedGold = Alloy.PHASED_GOLD.getOreIngot();
        String phasedIron = Alloy.PHASED_IRON.getOreIngot();
        String darkSteel = Alloy.DARK_STEEL.getOreIngot();
        String soularium = Alloy.SOULARIUM.getOreIngot();
        String endSteel = Alloy.END_STEEL.getOreIngot();
        String energeticSilver = AlloyEndergy.ENERGETIC_SILVER.getOreIngot();
        String vividAlloy = AlloyEndergy.VIVID_ALLOY.getOreIngot();
        String crystallineAlloy = AlloyEndergy.CRYSTALLINE_ALLOY.getOreIngot();
        String melodicAlloy = AlloyEndergy.MELODIC_ALLOY.getOreIngot();
        String stellarAlloy = AlloyEndergy.STELLAR_ALLOY.getOreIngot();
        String capacitor = Capacitors.BASIC_CAPACITOR.getOreTag();
        String capacitorEnder = Capacitors.ENDER_CAPACITOR.getOreTag();
        String string = ingotCopper = OreDictionary.doesOreNameExist((String)"ingotCopper") && Config.useModMetals ? "ingotCopper" : "ingotIron";
        if (Config.useHardRecipes) {
            RecipeUtil.addShaped(Capacitors.BASIC_CAPACITOR.getItemStack(), " gr", "gig", "rg ", Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), "ingotGold", Character.valueOf('i'), ingotCopper);
            RecipeUtil.addShaped(Capacitors.ACTIVATED_CAPACITOR.getItemStack(), "iii", "cCc", "iii", Character.valueOf('i'), energeticAlloy, Character.valueOf('c'), Capacitors.BASIC_CAPACITOR.getItemStack(), Character.valueOf('C'), "dustCoal");
            RecipeUtil.addShaped(Capacitors.ENDER_CAPACITOR.getItemStack(), "iii", "cCc", "iii", Character.valueOf('i'), phasedGold, Character.valueOf('c'), Capacitors.ACTIVATED_CAPACITOR.getItemStack(), Character.valueOf('C'), "glowstone");
            prismarine = OreDictionary.doesOreNameExist((String)"shardPrismarine") ? "shardPrismarine" : "itemPulsatingCrystal";
            RecipeUtil.addShaped(Capacitors.CRYSTALLINE_CAPACITOR.getItemStack(), "iii", "cCc", "iii", Character.valueOf('i'), crystallineAlloy, Character.valueOf('c'), capacitorEnder, Character.valueOf('C'), prismarine);
            RecipeUtil.addShaped(Capacitors.MELODIC_CAPACITOR.getItemStack(), "iii", "cCc", "iii", Character.valueOf('i'), melodicAlloy, Character.valueOf('c'), Capacitors.CRYSTALLINE_CAPACITOR.getItemStack(), Character.valueOf('C'), endSteel);
            RecipeUtil.addShaped(Capacitors.STELLAR_CAPACITOR.getItemStack(), "iii", "cCc", "iii", Character.valueOf('i'), stellarAlloy, Character.valueOf('c'), Capacitors.MELODIC_CAPACITOR.getItemStack(), Character.valueOf('C'), Material.PRECIENT_CRYSTAL.oreDict);
            RecipeUtil.addShaped(Capacitors.SILVER_CAPACITOR.getItemStack(), " sr", "sis", "rs ", Character.valueOf('r'), "dustRedstone", Character.valueOf('s'), "ingotSilver", Character.valueOf('i'), "ingotLead");
            RecipeUtil.addShaped(Capacitors.ENDERGETIC_CAPACITOR.getItemStack(), "iii", "cCc", "iii", Character.valueOf('i'), energeticSilver, Character.valueOf('c'), Capacitors.SILVER_CAPACITOR.getItemStack(), Character.valueOf('C'), "dustCoal");
            RecipeUtil.addShaped(Capacitors.ENDERGISED_CAPACITOR.getItemStack(), "iii", "cCc", "iii", Character.valueOf('i'), vividAlloy, Character.valueOf('c'), Capacitors.ENDERGETIC_CAPACITOR.getItemStack(), Character.valueOf('C'), "glowstone");
        } else {
            RecipeUtil.addShaped(Capacitors.BASIC_CAPACITOR.getItemStack(), " gr", "gig", "rg ", Character.valueOf('r'), "dustRedstone", Character.valueOf('g'), "ingotGold", Character.valueOf('i'), ingotCopper);
            RecipeUtil.addShaped(Capacitors.ACTIVATED_CAPACITOR.getItemStack(), " i ", "cCc", " i ", Character.valueOf('i'), energeticAlloy, Character.valueOf('c'), Capacitors.BASIC_CAPACITOR.getItemStack(), Character.valueOf('C'), "dustCoal");
            RecipeUtil.addShaped(Capacitors.ENDER_CAPACITOR.getItemStack(), " i ", "cCc", " i ", Character.valueOf('i'), phasedGold, Character.valueOf('c'), Capacitors.ACTIVATED_CAPACITOR.getItemStack(), Character.valueOf('C'), "glowstone");
            prismarine = OreDictionary.doesOreNameExist((String)"shardPrismarine") ? "shardPrismarine" : "itemPulsatingCrystal";
            RecipeUtil.addShaped(Capacitors.CRYSTALLINE_CAPACITOR.getItemStack(), " i ", "cCc", " i ", Character.valueOf('i'), crystallineAlloy, Character.valueOf('c'), capacitorEnder, Character.valueOf('C'), prismarine);
            RecipeUtil.addShaped(Capacitors.MELODIC_CAPACITOR.getItemStack(), " i ", "cCc", " i ", Character.valueOf('i'), melodicAlloy, Character.valueOf('c'), Capacitors.CRYSTALLINE_CAPACITOR.getItemStack(), Character.valueOf('C'), endSteel);
            RecipeUtil.addShaped(Capacitors.STELLAR_CAPACITOR.getItemStack(), " i ", "cCc", " i ", Character.valueOf('i'), stellarAlloy, Character.valueOf('c'), Capacitors.MELODIC_CAPACITOR.getItemStack(), Character.valueOf('C'), Material.PRECIENT_CRYSTAL.oreDict);
            RecipeUtil.addShaped(Capacitors.SILVER_CAPACITOR.getItemStack(), " sr", "sis", "rs ", Character.valueOf('r'), "dustRedstone", Character.valueOf('s'), "ingotSilver", Character.valueOf('i'), "ingotLead");
            RecipeUtil.addShaped(Capacitors.ENDERGETIC_CAPACITOR.getItemStack(), " i ", "cCc", " i ", Character.valueOf('i'), energeticSilver, Character.valueOf('c'), Capacitors.SILVER_CAPACITOR.getItemStack(), Character.valueOf('C'), "dustCoal");
            RecipeUtil.addShaped(Capacitors.ENDERGISED_CAPACITOR.getItemStack(), " i ", "cCc", " i ", Character.valueOf('i'), vividAlloy, Character.valueOf('c'), Capacitors.ENDERGETIC_CAPACITOR.getItemStack(), Character.valueOf('C'), "glowstone");
        }
        ItemStack cbc = Material.BINDER_COMPOSITE.getStack(8);
        if (Config.useAlternateBinderRecipe) {
            RecipeUtil.addShaped(cbc, "gcg", "sgs", "gcg", Character.valueOf('g'), Blocks.field_150351_n, Character.valueOf('s'), "sand", Character.valueOf('c'), Items.field_151119_aD);
        } else {
            RecipeUtil.addShaped(cbc, "ggg", "scs", "ggg", Character.valueOf('g'), Blocks.field_150351_n, Character.valueOf('s'), "sand", Character.valueOf('c'), Items.field_151119_aD);
        }
        GameRegistry.addSmelting((ItemStack)Material.BINDER_COMPOSITE.getStack(), (ItemStack)Material.CONDUIT_BINDER.getStack(4), (float)0.0f);
        ItemStack phasedIronNugget = new ItemStack((Item)EnderIO.itemMaterial, 9, Material.PHASED_IRON_NUGGET.ordinal());
        RecipeUtil.addShapeless(phasedIronNugget, phasedIron);
        phasedIronNugget = phasedIronNugget.func_77946_l();
        phasedIronNugget.field_77994_a = 1;
        RecipeUtil.addShaped(Alloy.PHASED_IRON.getStackIngot(), "eee", "eee", "eee", Character.valueOf('e'), phasedIronNugget);
        ItemStack vibrantNugget = new ItemStack((Item)EnderIO.itemMaterial, 9, Material.VIBRANT_NUGGET.ordinal());
        RecipeUtil.addShapeless(vibrantNugget, phasedGold);
        vibrantNugget = vibrantNugget.func_77946_l();
        vibrantNugget.field_77994_a = 1;
        RecipeUtil.addShaped(Alloy.PHASED_GOLD.getStackIngot(), "eee", "eee", "eee", Character.valueOf('e'), vibrantNugget);
        ItemStack endSteelNugget = new ItemStack((Item)EnderIO.itemMaterial, 9, Material.END_STEEL_NUGGET.ordinal());
        RecipeUtil.addShapeless(endSteelNugget, endSteel);
        endSteelNugget = endSteelNugget.func_77946_l();
        endSteelNugget.field_77994_a = 1;
        RecipeUtil.addShaped(Alloy.END_STEEL.getStackIngot(), "eee", "eee", "eee", Character.valueOf('e'), endSteelNugget);
        ItemStack pulsCry = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.PULSATING_CYSTAL.ordinal());
        RecipeUtil.addShaped(pulsCry, "nnn", "ngn", "nnn", Character.valueOf('n'), phasedIronNugget, Character.valueOf('g'), "gemDiamond");
        ItemStack vibCry = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_CYSTAL.ordinal());
        RecipeUtil.addShaped(vibCry, "nnn", "ngn", "nnn", Character.valueOf('n'), vibrantNugget, Character.valueOf('g'), "gemEmerald");
        if (!EnderIO.hasGT5) {
            ItemStack dustIron = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_IRON.ordinal());
            ItemStack dustGold = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_GOLD.ordinal());
            ItemStack ingotIron = new ItemStack(Items.field_151042_j);
            ItemStack ingotGold = new ItemStack(Items.field_151043_k);
            GameRegistry.addSmelting((ItemStack)dustIron, (ItemStack)ingotIron, (float)0.0f);
            GameRegistry.addSmelting((ItemStack)dustGold, (ItemStack)ingotGold, (float)0.0f);
            ItemStack enderDust = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_ENDER.ordinal());
            RecipeUtil.addShaped(new ItemStack(Items.field_151079_bi), "eee", "eee", "eee", Character.valueOf('e'), enderDust);
        }
        ItemStack diBars = new ItemStack((Block)EnderIO.blockDarkIronBars, 16, 0);
        RecipeUtil.addShaped(diBars, "ddd", "ddd", Character.valueOf('d'), darkSteel);
        ItemStack soBars = new ItemStack((Block)EnderIO.blockSoulariumBars, 16, 0);
        RecipeUtil.addShaped(soBars, "ddd", "ddd", Character.valueOf('d'), soularium);
        ItemStack esBars = new ItemStack((Block)EnderIO.blockEndSteelBars, 16, 0);
        RecipeUtil.addShaped(esBars, "ddd", "ddd", Character.valueOf('d'), endSteel);
        RecipeUtil.addShaped(fusedQuartzFrame, "bsb", "s s", "bsb", Character.valueOf('b'), conduitBinder, Character.valueOf('s'), "stickWood");
        RecipeUtil.addShaped(fusedQuartzFrame, "bsb", "s s", "bsb", Character.valueOf('b'), conduitBinder, Character.valueOf('s'), "woodStick");
        ArrayList steelIngots = OreDictionary.getOres((String)"ingotSteel");
        ItemStack chassis = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.MACHINE_CHASSI.ordinal());
        String mat = Config.useSteelInChassi && steelIngots != null && !steelIngots.isEmpty() ? "ingotSteel" : "ingotIron";
        RecipeUtil.addShaped(chassis, "fif", "ici", "fif", Character.valueOf('f'), Blocks.field_150411_aY, Character.valueOf('i'), mat, Character.valueOf('c'), capacitor);
        ItemStack soulchassis = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.SOUL_MACHINE_CHASSIS.ordinal());
        RecipeUtil.addShaped(soulchassis, new Object[]{"fif", "ici", "fif", Character.valueOf('f'), EnderIO.blockSoulariumBars, Character.valueOf('i'), Alloy.SOULARIUM.getOreIngot(), Character.valueOf('c'), capacitor});
        ItemStack endchassis = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.END_STEEL_MACHINE_CHASSIS.ordinal());
        RecipeUtil.addShaped(endchassis, new Object[]{"fif", "ici", "fif", Character.valueOf('f'), EnderIO.blockEndSteelBars, Character.valueOf('i'), Alloy.END_STEEL.getOreIngot(), Character.valueOf('c'), capacitor});
        ItemStack gear = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.BASIC_GEAR.ordinal());
        RecipeUtil.addShaped(gear, "scs", "c c", "scs", Character.valueOf('s'), "stickWood", Character.valueOf('c'), "cobblestone");
        RecipeUtil.addShaped(gear, "scs", "c c", "scs", Character.valueOf('s'), "woodStick", Character.valueOf('c'), "cobblestone");
        ItemStack main = Config.useHardRecipes ? new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_CYSTAL.ordinal()) : new ItemStack(Items.field_151045_i);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)EnderIO.itemMaterial, 1, Material.WEATHER_CRYSTAL.ordinal()), new Object[]{main}));
        if (Config.reinforcedObsidianEnabled) {
            Enum[] reinfObs = new ItemStack((Block)EnderIO.blockReinforcedObsidian);
            String corners = darkSteel;
            if (Config.reinforcedObsidianUseDarkSteelBlocks) {
                corners = Alloy.DARK_STEEL.getOreBlock();
            }
            RecipeUtil.addShaped((ItemStack)reinfObs, new Object[]{"dbd", "bob", "dbd", Character.valueOf('d'), corners, Character.valueOf('b'), EnderIO.blockDarkIronBars, Character.valueOf('o'), Blocks.field_150343_Z});
        }
        RecipeUtil.addShaped((Block)EnderIO.blockDarkSteelAnvil, "bbb", " i ", "iii", Character.valueOf('b'), Alloy.DARK_STEEL.getOreBlock(), Character.valueOf('i'), darkSteel);
        RecipeUtil.addShaped(new ItemStack((Block)EnderIO.blockDarkSteelLadder, 12), new Object[]{"b", "b", "b", Character.valueOf('b'), EnderIO.blockDarkIronBars});
        for (Alloy alloy : Alloy.values()) {
            RecipeUtil.addShaped(alloy.getStackBlock(), "iii", "iii", "iii", Character.valueOf('i'), alloy.getOreIngot());
            RecipeUtil.addShaped(alloy.getStackBall(5), " i ", "iii", " i ", Character.valueOf('i'), alloy.getOreIngot());
            RecipeUtil.addShapeless(alloy.getStackIngot(9), alloy.getOreBlock());
        }
        for (Enum enum_ : AlloyEndergy.values()) {
            RecipeUtil.addShaped(((AlloyEndergy)enum_).getStackBlock(), "iii", "iii", "iii", Character.valueOf('i'), ((AlloyEndergy)enum_).getOreIngot());
            RecipeUtil.addShaped(((AlloyEndergy)enum_).getStackBall(5), " i ", "iii", " i ", Character.valueOf('i'), ((AlloyEndergy)enum_).getOreIngot());
            RecipeUtil.addShapeless(((AlloyEndergy)enum_).getStackIngot(9), ((AlloyEndergy)enum_).getOreBlock());
        }
        ItemStack darkRod = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.DARK_STEEL_ROD.ordinal());
        RecipeUtil.addShaped(darkRod, " ns", "nsn", "sn ", Character.valueOf('s'), darkSteel, Character.valueOf('n'), endSteelNugget);
        if (!EnderIO.hasGT5) {
            ItemStack flour = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.FLOUR.ordinal());
            ItemStack bread = new ItemStack(Items.field_151025_P, 1, 0);
            GameRegistry.addSmelting((ItemStack)flour, (ItemStack)bread, (float)0.35f);
        }
        ItemStack enderios = ItemEnderFood.EnderFood.ENDERIOS.getStack();
        RecipeUtil.addShapeless(enderios, Items.field_151054_z, Items.field_151117_aB, "cropWheat", "dustEnderPearl");
        if (!EnderIO.hasGT5) {
            if (OreDictionaryHelper.hasCopper()) {
                ItemStack dustCopper = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_COPPER.ordinal());
                ItemStack itemStack = OreDictionaryPreferences.instance.getPreferred("ingotCopper");
                GameRegistry.addSmelting((ItemStack)dustCopper, (ItemStack)itemStack, (float)0.0f);
            }
            if (OreDictionaryHelper.hasTin()) {
                ItemStack dustTin = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_TIN.ordinal());
                ItemStack itemStack = OreDictionaryPreferences.instance.getPreferred("ingotTin");
                GameRegistry.addSmelting((ItemStack)dustTin, (ItemStack)itemStack, (float)0.0f);
            }
        }
    }
}

