/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityFallenMount
extends EntityHorse
implements IEnderZooMob {
    public static final int EGG_BG_COL = 3562021;
    public static final int EGG_FG_COL = 0xA0A0A0;
    public static String NAME = "enderzoo.FallenMount";
    public static final double MOUNTED_ATTACK_MOVE_SPEED = Config.fallenMountChargeSpeed;
    private boolean wasRidden = false;
    private final EntityAINearestAttackableTarget findTargetAI;
    private EntityAIAttackOnCollide attackAI;
    private ItemStack armor;

    public EntityFallenMount(World world) {
        super(world);
        this.func_70873_a(0);
        this.func_110251_o(true);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.findTargetAI = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true);
        this.attackAI = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, MOUNTED_ATTACK_MOVE_SPEED, false);
        this.updateAttackAI();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        MobInfo.FALLEN_MOUNT.applyAttributes((EntityLivingBase)this);
    }

    protected boolean func_70610_aX() {
        return this.func_110209_cd();
    }

    public boolean func_70085_c(EntityPlayer p_70085_1_) {
        ItemStack itemstack = p_70085_1_.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151063_bx) {
            return super.func_70085_c(p_70085_1_);
        }
        return false;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public boolean func_70878_b(EntityAnimal p_70878_1_) {
        return false;
    }

    public boolean func_110164_bC() {
        return false;
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return false;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.monster;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        float chanceOfArmor;
        this.func_110214_p(3);
        this.func_110251_o(true);
        this.func_70873_a(0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.fallenMountHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111152_a("horse.jumpStrength").func_111128_a(0.5);
        this.func_70606_j(this.func_110138_aP());
        float f = chanceOfArmor = this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? Config.fallenMountChanceArmoredHard : Config.fallenMountChanceArmored;
        if (this.field_70146_Z.nextFloat() <= chanceOfArmor) {
            float occupiedDiffcultyMultiplier = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            float chanceImprovedArmor = this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? Config.fallenMountChanceArmorUpgradeHard : Config.fallenMountChanceArmorUpgrade;
            chanceImprovedArmor *= 1.0f + (occupiedDiffcultyMultiplier /= 1.5f);
            int armorLevel = 0;
            for (int i = 0; i < 2; ++i) {
                if (!(this.field_70146_Z.nextFloat() <= chanceImprovedArmor)) continue;
                ++armorLevel;
            }
            Item armorItem = Items.field_151138_bX;
            switch (armorLevel) {
                case 1: {
                    armorItem = Items.field_151136_bY;
                    break;
                }
                case 2: {
                    armorItem = Items.field_151125_bZ;
                }
            }
            this.armor = new ItemStack(armorItem);
            this.func_146086_d(this.armor);
        }
        return data;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        float f;
        super.func_70636_d();
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.burnInSun() && this.field_70170_p.func_82737_E() % 20L == 0L && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
            this.func_70015_d(8);
        }
        this.func_70019_c(false);
        if (this.wasRidden != this.isRidden()) {
            this.updateAttackAI();
            this.wasRidden = this.isRidden();
        }
    }

    private boolean burnInSun() {
        if (!this.isRidden()) {
            return this.func_70658_aO() == 0;
        }
        if (Config.fallenMountShadedByRider) {
            return false;
        }
        return this.func_70658_aO() > 0;
    }

    protected boolean isRidden() {
        return this.field_70153_n != null;
    }

    private void updateAttackAI() {
        this.field_70715_bh.func_85156_a((EntityAIBase)this.findTargetAI);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.attackAI);
        if (!this.isRidden()) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.findTargetAI);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.attackAI);
        }
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        Entity prev = this.field_70153_n;
        this.field_70153_n = null;
        super.func_70612_e(p_70612_1_, p_70612_2_);
        this.field_70153_n = prev;
    }

    public boolean func_70652_k(Entity target) {
        if (this.isRidden() || this.field_70128_L) {
            return false;
        }
        super.func_70652_k(target);
        if (!this.func_110209_cd()) {
            this.func_110231_cz();
        }
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        if (this.armor != null) {
            NBTTagCompound armTag = new NBTTagCompound();
            this.armor.func_77955_b(armTag);
            root.func_74782_a("armor", (NBTBase)armTag);
        }
    }

    public void func_70037_a(NBTTagCompound root) {
        super.func_70037_a(root);
        this.func_110251_o(true);
        if (root.func_74764_b("armor")) {
            NBTTagCompound armTag = root.func_74775_l("armor");
            this.armor = ItemStack.func_77949_a((NBTTagCompound)armTag);
            this.func_146086_d(this.armor);
        }
    }
}

