/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesCustom;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IPollinatable;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeGenome;
import forestry.arboriculture.genetics.pollination.FakePollinatable;
import forestry.arboriculture.genetics.pollination.ICheckPollinatable;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Log;
import forestry.core.utils.MathUtil;
import forestry.core.utils.StringUtil;
import forestry.core.utils.vect.Vect;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Bee
extends IndividualLiving
implements IBee {
    private int generation;
    private boolean isNatural = true;
    private IBeeGenome genome;
    private IBeeGenome mate;

    public Bee(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Bee(IBeeGenome genome, IBee mate) {
        this(genome);
        this.mate = mate.getGenome();
    }

    public Bee(IBeeGenome genome) {
        this(genome, true, 0);
    }

    private Bee(IBeeGenome genome, boolean isNatural, int generation) {
        super(genome.getLifespan());
        this.genome = genome;
        this.isNatural = isNatural;
        this.generation = generation;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            this.genome = BeeDefinition.FOREST.getGenome();
            return;
        }
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("NA")) {
            this.isNatural = nbttagcompound.func_74767_n("NA");
        }
        if (nbttagcompound.func_74764_b("GEN")) {
            this.generation = nbttagcompound.func_74762_e("GEN");
        }
        this.genome = nbttagcompound.func_74764_b("Genome") ? BeeGenome.fromNBT(nbttagcompound.func_74775_l("Genome")) : BeeDefinition.FOREST.getGenome();
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = BeeGenome.fromNBT(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (!this.isNatural) {
            nbttagcompound.func_74757_a("NA", false);
        }
        if (this.generation > 0) {
            nbttagcompound.func_74768_a("GEN", this.generation);
        }
    }

    @Override
    public void setIsNatural(boolean flag) {
        this.isNatural = flag;
    }

    @Override
    public boolean isNatural() {
        return this.isNatural;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void mate(IIndividual individual) {
        if (!(individual instanceof IBee)) {
            return;
        }
        IBee drone = (IBee)individual;
        this.mate = drone.getGenome();
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doEffect(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, housing);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doFX(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doFX(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        return effect.doFX(this.genome, storedData, housing);
    }

    @Override
    public IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    public IBeeGenome getMate() {
        return this.mate;
    }

    @Override
    public IBee copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Bee(nbttagcompound);
    }

    @Override
    public boolean canSpawn() {
        return this.mate != null;
    }

    @Override
    public Set<IErrorState> getCanWork(IBeeHousing housing) {
        EnumTolerance beeToleranceHumidity;
        EnumHumidity beeBaseHumidity;
        EnumHumidity actualHumidity;
        EnumTolerance beeToleranceTemperature;
        EnumTemperature beeBaseTemperature;
        World world = housing.getWorld();
        BiomeGenBase biome = housing.getBiome();
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        if (world.func_72896_J() && BiomeHelper.canRainOrSnow(biome) && !this.canFlyInRain(beeModifier)) {
            errorStates.add(EnumErrorCode.IS_RAINING);
        }
        if (world.func_72935_r()) {
            if (!this.canWorkDuringDay(beeModifier)) {
                errorStates.add(EnumErrorCode.NOT_NIGHT);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(EnumErrorCode.NOT_DAY);
        }
        if (housing.getBlockLightValue() > 11) {
            if (!this.canWorkDuringDay(beeModifier)) {
                errorStates.add(EnumErrorCode.NOT_GLOOMY);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(EnumErrorCode.NOT_BRIGHT);
        }
        if (!(world.field_73011_w.field_76576_e || housing.canBlockSeeTheSky() || this.canWorkUnderground(beeModifier))) {
            errorStates.add(EnumErrorCode.NO_SKY);
        }
        IAlleleBeeSpecies species = this.genome.getPrimary();
        EnumTemperature actualTemperature = housing.getTemperature();
        if (!AlleleManager.climateHelper.isWithinLimits(actualTemperature, beeBaseTemperature = species.getTemperature(), beeToleranceTemperature = this.genome.getToleranceTemp())) {
            if (beeBaseTemperature.ordinal() > actualTemperature.ordinal()) {
                errorStates.add(EnumErrorCode.TOO_COLD);
            } else {
                errorStates.add(EnumErrorCode.TOO_HOT);
            }
        }
        if (!AlleleManager.climateHelper.isWithinLimits(actualHumidity = housing.getHumidity(), beeBaseHumidity = species.getHumidity(), beeToleranceHumidity = this.genome.getToleranceHumid())) {
            if (beeBaseHumidity.ordinal() > actualHumidity.ordinal()) {
                errorStates.add(EnumErrorCode.TOO_ARID);
            } else {
                errorStates.add(EnumErrorCode.TOO_HUMID);
            }
        }
        return errorStates;
    }

    private boolean canWorkAtNight(IBeeModifier beeModifier) {
        return !(!this.genome.getPrimary().isNocturnal() && !this.genome.getNocturnal() && !beeModifier.isSelfLighted() || beeModifier.isSelfUnlighted() && beeModifier.isSelfLighted());
    }

    private boolean canWorkDuringDay(IBeeModifier beeModifier) {
        return !(this.genome.getPrimary().isNocturnal() && !this.genome.getNocturnal() && !beeModifier.isSelfUnlighted() || beeModifier.isSelfUnlighted() && beeModifier.isSelfLighted());
    }

    private boolean canWorkUnderground(IBeeModifier beeModifier) {
        return this.genome.getCaveDwelling() || beeModifier.isSunlightSimulated();
    }

    private boolean canFlyInRain(IBeeModifier beeModifier) {
        return this.genome.getTolerantFlyer() || beeModifier.isSealed();
    }

    private boolean isSuitableBiome(BiomeGenBase biome) {
        if (biome == null) {
            return false;
        }
        EnumTemperature temperature = EnumTemperature.getFromBiome(biome);
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.field_76751_G);
        return this.isSuitableClimate(temperature, humidity);
    }

    private boolean isSuitableClimate(EnumTemperature temperature, EnumHumidity humidity) {
        return AlleleManager.climateHelper.isWithinLimits(temperature, humidity, this.genome.getPrimary().getTemperature(), this.genome.getToleranceTemp(), this.genome.getPrimary().getHumidity(), this.genome.getToleranceHumid());
    }

    public ArrayList<BiomeGenBase> getSuitableBiomes() {
        ArrayList<BiomeGenBase> suitableBiomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (!this.isSuitableBiome(biome)) continue;
            suitableBiomes.add(biome);
        }
        return suitableBiomes;
    }

    @Override
    public void addLore(List<String> text) {
        String speciesLore;
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        String[] descTokens = primary.getDescription().split("\\|");
        if (descTokens.length > 0 && !(speciesLore = descTokens[0]).isEmpty() && !speciesLore.contains("for.description")) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            String formattedLore = EnumChatFormatting.GOLD + speciesLore;
            List formattedLoreList = fontRenderer.func_78271_c(formattedLore, 200);
            text.addAll(formattedLoreList);
        }
    }

    @Override
    public void addDiscoveredBy(List<String> text) {
        String discoveredBy;
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        String[] descTokens = primary.getDescription().split("\\|");
        if (descTokens.length > 2 && !(discoveredBy = descTokens[2]).isEmpty()) {
            text.add("");
            text.add("Discovered by " + EnumChatFormatting.ITALIC + discoveredBy);
        }
    }

    @Override
    public void addTooltip(List<String> list) {
        IJubilanceProvider provider;
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumBeeChromosome.SPECIES)) {
            list.add(EnumChatFormatting.BLUE + StringUtil.localize("bees.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        if (this.generation > 0) {
            EnumRarity rarity = this.generation >= 1000 ? EnumRarity.epic : (this.generation >= 100 ? EnumRarity.rare : (this.generation >= 10 ? EnumRarity.uncommon : EnumRarity.common));
            String generationString = rarity.field_77937_e + StringUtil.localizeAndFormat("gui.beealyzer.generations", this.generation);
            list.add(generationString);
        }
        IAllele speedAllele = this.genome.getActiveAllele(EnumBeeChromosome.SPEED);
        IAlleleTolerance tempToleranceAllele = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        IAlleleTolerance humidToleranceAllele = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        String unlocalizedCustomSpeed = "tooltip.worker." + speedAllele.getUnlocalizedName().replaceAll("(.*)\\.", "");
        String speed = StringUtil.canTranslate(unlocalizedCustomSpeed) ? StringUtil.localize(unlocalizedCustomSpeed) : speedAllele.getName() + ' ' + StringUtil.localize("gui.worker");
        String lifespan = this.genome.getActiveAllele(EnumBeeChromosome.LIFESPAN).getName() + ' ' + StringUtil.localize("gui.life");
        String tempTolerance = EnumChatFormatting.GREEN + "T: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getTemperature()) + " / " + tempToleranceAllele.getName();
        String humidTolerance = EnumChatFormatting.GREEN + "H: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getHumidity()) + " / " + humidToleranceAllele.getName();
        String flowers = this.genome.getFlowerProvider().getDescription();
        String jubilance = null;
        if (primary instanceof IAlleleBeeSpeciesCustom && (provider = ((IAlleleBeeSpeciesCustom)primary).getJubilanceProvider()) != null) {
            jubilance = provider.getDescription();
        }
        list.add(lifespan);
        list.add(speed);
        list.add(tempTolerance);
        list.add(humidTolerance);
        list.add(flowers);
        if (jubilance != null) {
            list.add(StringUtil.localizeAndFormat("gui.jubilance", jubilance));
        }
        if (this.genome.getNocturnal()) {
            list.add(EnumChatFormatting.RED + GenericRatings.rateActivityTime(this.genome.getNocturnal(), false));
        }
        if (this.genome.getTolerantFlyer()) {
            list.add(EnumChatFormatting.WHITE + StringUtil.localize("gui.flyer.tooltip"));
        }
    }

    @Override
    public void age(World world, float housingLifespanModifier) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        IBeeModifier beeModifier = mode.getBeeModifier();
        float finalModifier = housingLifespanModifier * beeModifier.getLifespanModifier(this.genome, this.mate, housingLifespanModifier);
        super.age(world, finalModifier);
    }

    @Override
    public ItemStack[] getProduceList() {
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        ArrayList<ItemStack> products = new ArrayList<ItemStack>(primary.getProductChances().keySet());
        Set<ItemStack> secondaryProducts = secondary.getProductChances().keySet();
        for (ItemStack second : secondaryProducts) {
            boolean skip = false;
            for (ItemStack compare : products) {
                if (!second.func_77969_a(compare)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            products.add(second);
        }
        return products.toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] getSpecialtyList() {
        Set<ItemStack> specialties = this.genome.getPrimary().getSpecialtyChances().keySet();
        return specialties.toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] produceStacks(IBeeHousing housing) {
        if (housing == null) {
            Log.warning("Failed to produce in an apiary because the beehousing was null.");
            return null;
        }
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(housing.getWorld());
        if (mode == null) {
            Log.warning("Failed to produce in an apiary because the beekeeping mode was null.");
            return null;
        }
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (mode.isOverworked(this, housing)) {
            this.setIsNatural(false);
        }
        IBeeModifier beeHousingModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        IBeeModifier beeModeModifier = mode.getBeeModifier();
        float speed = this.genome.getSpeed();
        float prodModifier = beeHousingModifier.getProductionModifier(this.genome, 0.0f);
        prodModifier += beeModeModifier.getProductionModifier(this.genome, prodModifier);
        for (Map.Entry<ItemStack, Float> entry : primary.getProductChances().entrySet()) {
            if (!(housing.getWorld().field_73012_v.nextFloat() < Bee.getFinalChance(entry.getValue().floatValue(), speed, prodModifier, 1.0f))) continue;
            products.add(entry.getKey().func_77946_l());
        }
        for (Map.Entry<ItemStack, Float> entry : secondary.getProductChances().entrySet()) {
            if (!(housing.getWorld().field_73012_v.nextFloat() < Bee.getFinalChance(entry.getValue().floatValue() / 2.0f, speed, prodModifier, 1.0f))) continue;
            products.add(entry.getKey().func_77946_l());
        }
        if (primary.isJubilant(this.genome, housing) && secondary.isJubilant(this.genome, housing)) {
            for (Map.Entry<ItemStack, Float> entry : primary.getSpecialtyChances().entrySet()) {
                if (!(housing.getWorld().field_73012_v.nextFloat() < Bee.getFinalChance(entry.getValue().floatValue(), speed, prodModifier, 1.0f))) continue;
                products.add(entry.getKey().func_77946_l());
            }
        }
        ItemStack[] productsArray = products.toArray(new ItemStack[0]);
        ChunkCoordinates housingCoordinates = housing.getCoordinates();
        return this.genome.getFlowerProvider().affectProducts(housing.getWorld(), this, housingCoordinates.field_71574_a, housingCoordinates.field_71572_b, housingCoordinates.field_71573_c, productsArray);
    }

    public static float getFinalChance(float chance, float beeSpeed, float productionModifier, float t) {
        if (productionModifier + t <= 0.0f) {
            return 0.0f;
        }
        return (float)(2.8 * Math.pow(chance *= 100.0f, 0.52) * Math.pow(productionModifier + t, 0.52) * Math.pow(beeSpeed, 0.37)) / 100.0f;
    }

    @Override
    public IBee spawnPrincess(IBeeHousing housing) {
        if (this.mate == null) {
            return null;
        }
        if (BeeManager.beeRoot.getBeekeepingMode(housing.getWorld()).isFatigued(this, housing)) {
            return null;
        }
        return this.createOffspring(housing, this.getGeneration() + 1);
    }

    @Override
    public IBee[] spawnDrones(IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.mate == null) {
            return null;
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        ChunkCoordinates housingCoordinates = housing.getCoordinates();
        int toCreate = BeeManager.beeRoot.getBeekeepingMode(world).getFinalFertility(this, world, housingCoordinates.field_71574_a, housingCoordinates.field_71572_b, housingCoordinates.field_71573_c);
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(housing, 0);
            if (offspring == null) continue;
            offspring.setIsNatural(true);
            bees.add(offspring);
        }
        if (bees.size() > 0) {
            return bees.toArray(new IBee[bees.size()]);
        }
        return null;
    }

    private IBee createOffspring(IBeeHousing housing, int generation) {
        IChromosome[] mutated2;
        World world = housing.getWorld();
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = Bee.mutateSpecies(housing, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = Bee.mutateSpecies(housing, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        return new Bee(new BeeGenome(chromosomes), mode.isNaturalOffspring(this), generation);
    }

    private static IChromosome[] mutateSpecies(IBeeHousing housing, IBeeGenome genomeOne, IBeeGenome genomeTwo) {
        IBeeGenome genome1;
        IBeeGenome genome0;
        IAlleleBeeSpecies allele1;
        IAlleleBeeSpecies allele0;
        World world = housing.getWorld();
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = (IAlleleBeeSpecies)parent1[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleBeeSpecies)parent2[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = (IAlleleBeeSpecies)parent2[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleBeeSpecies)parent1[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        GameProfile playerProfile = housing.getOwner();
        IApiaristTracker breedingTracker = BeeManager.beeRoot.getBreedingTracker(world, playerProfile);
        List<IMutation> combinations = BeeManager.beeRoot.getCombinations(allele0, allele1, true);
        for (IMutation mutation : combinations) {
            IBeeMutation beeMutation = (IBeeMutation)mutation;
            float chance = beeMutation.getChance(housing, allele0, allele1, genome0, genome1);
            if (chance <= 0.0f) continue;
            if (breedingTracker.isResearched(beeMutation)) {
                float mutationBoost = MathUtil.safeMultiply(chance, Config.researchMutationBoostMultiplier - 1.0f);
                mutationBoost = Math.min(Config.maxResearchMutationBoostPercent, mutationBoost);
                chance = MathUtil.safeAdd(chance, mutationBoost);
            }
            if (!(chance > world.field_73012_v.nextFloat() * 100.0f)) continue;
            breedingTracker.registerMutation(mutation);
            return BeeManager.beeRoot.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    public IIndividual retrievePollen(IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = Math.round((float)this.genome.getFlowering() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorld();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return null;
        }
        Vect area = Bee.getArea(this.genome, beeModifier);
        Vect offset = new Vect(-area.x / 2, -area.y / 4, -area.z / 2);
        Vect housingPos = new Vect(housing.getCoordinates());
        IIndividual pollen = null;
        for (int i = 0; i < 20; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(random, area);
            Vect blockPos = Vect.add(housingPos, randomPos, offset);
            if (!world.func_72899_e(blockPos.x, blockPos.y, blockPos.z)) continue;
            TileEntity tile = world.func_147438_o(blockPos.x, blockPos.y, blockPos.z);
            if (tile instanceof IPollinatable) {
                IPollinatable pitcher = (IPollinatable)tile;
                if (this.genome.getFlowerProvider().isAcceptedPollinatable(world, pitcher)) {
                    pollen = pitcher.getPollen();
                }
            } else {
                pollen = GeneticsUtil.getErsatzPollen(world, blockPos.x, blockPos.y, blockPos.z);
            }
            if (pollen == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    public boolean pollinateRandom(IBeeHousing housing, IIndividual pollen) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = (int)((float)this.genome.getFlowering() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorld();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return false;
        }
        Vect area = Bee.getArea(this.genome, beeModifier);
        Vect offset = new Vect(-area.x / 2, -area.y / 4, -area.z / 2);
        Vect housingPos = new Vect(housing.getCoordinates());
        for (int i = 0; i < 30; ++i) {
            IPollinatable realPollinatable;
            Vect randomPos = Vect.getRandomPositionInArea(random, area);
            Vect posBlock = Vect.add(housingPos, randomPos, offset);
            ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(world, posBlock.x, posBlock.y, posBlock.z);
            if (checkPollinatable == null || !this.genome.getFlowerProvider().isAcceptedPollinatable(world, new FakePollinatable(checkPollinatable)) || !checkPollinatable.canMateWith(pollen) || (realPollinatable = GeneticsUtil.getOrCreatePollinatable(housing.getOwner(), world, posBlock.x, posBlock.y, posBlock.z)) == null) continue;
            realPollinatable.mateWith(pollen);
            return true;
        }
        return false;
    }

    @Override
    public void plantFlowerRandom(IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = Math.round((float)this.genome.getFlowering() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorld();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return;
        }
        IFlowerProvider provider = this.genome.getFlowerProvider();
        Vect area = Bee.getArea(this.genome, beeModifier);
        Vect offset = new Vect(-area.x / 2, -area.y / 4, -area.z / 2);
        Vect housingPos = new Vect(housing.getCoordinates());
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(random, area);
            Vect posBlock = Vect.add(housingPos, randomPos, offset);
            if (FlowerManager.flowerRegistry.growFlower(provider.getFlowerType(), world, this, posBlock.x, posBlock.y, posBlock.z)) break;
        }
    }

    private static Vect getArea(IBeeGenome genome, IBeeModifier beeModifier) {
        int[] genomeTerritory = genome.getTerritory();
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return new Vect(genomeTerritory).multiply(housingModifier * 3.0f);
    }
}

