/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.apiculture.worldgen.Hive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HiveRegistry
implements IHiveRegistry {
    private final Map<String, Hive> hives = new HashMap<String, Hive>();

    @Override
    public void registerHive(String hiveName, IHiveDescription hiveDescription) {
        if (this.hives.containsKey(hiveName)) {
            throw new IllegalArgumentException("Hive already exists with name: " + hiveName);
        }
        Hive hive = new Hive(hiveDescription);
        this.hives.put(hiveName, hive);
    }

    @Override
    public void addDrops(String hiveName, IHiveDrop ... drops) {
        this.addDrops(hiveName, Arrays.asList(drops));
    }

    @Override
    public void addDrops(String hiveName, List<IHiveDrop> drops) {
        Hive hive = this.hives.get(hiveName);
        if (hive == null) {
            throw new IllegalArgumentException("No hive registered with name: " + hiveName);
        }
        hive.addDrops(drops);
    }

    public List<Hive> getHives() {
        return new ArrayList<Hive>(this.hives.values());
    }

    public List<IHiveDrop> getDrops(String hiveName) {
        Hive hive = this.hives.get(hiveName);
        if (hive == null) {
            throw new IllegalArgumentException("No hive registered with name: " + hiveName);
        }
        return hive.getDrops();
    }
}

