/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenKapok
extends WorldGenTree {
    public WorldGenKapok(ITreeGenData tree) {
        super(tree, 10, 8);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth, 0.6f);
        this.generateSupportStems(world, this.height, this.girth, 0.8f, 0.4f);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        ArrayList<ChunkCoordinates> branchCoords = new ArrayList<ChunkCoordinates>();
        while (leafSpawn > this.height - 4) {
            int radius = Math.round((float)(this.girth * (this.height - leafSpawn)) / 1.5f) + 6;
            branchCoords.addAll(this.generateBranches(world, leafSpawn, 0, 0, 0.3f, 0.25f, radius, 6));
            leafSpawn -= 2;
        }
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.field_71572_b + 1, branchEnd.field_71574_a, branchEnd.field_71573_c, 2.0f, 2, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + world.field_73012_v.nextInt(Math.max(1, this.height - 10));
            if (world.field_73012_v.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + world.field_73012_v.nextInt(this.height / 2);
            }
            int x_off = -1 + world.field_73012_v.nextInt(3);
            int y_off = -1 + world.field_73012_v.nextInt(3);
            this.generateSphere(world, new WorldGenBase.Vector(x_off, h, y_off), 1 + world.field_73012_v.nextInt(1), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }
}

