/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.Forestry;
import forestry.api.core.IGameMode;
import forestry.core.blocks.BlockSoil;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.utils.Log;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginFluids;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GameMode
implements IGameMode {
    private static final String GAMEMODE_KEY = "gamemode";
    private String identifier = "EASY";
    private final String category;
    private final Map<String, Boolean> booleanSettings = new HashMap<String, Boolean>();
    private final Map<String, Integer> integerSettings = new HashMap<String, Integer>();
    private final Map<String, Float> floatSettings = new HashMap<String, Float>();
    private final Map<String, ItemStack> stackSettings = new HashMap<String, ItemStack>();
    private static final float ENERGY_DEMAND_MODIFIER = 1.0f;
    private static final float FUEL_MODIFIER = 1.0f;
    private static final int FARM_FERTILIZER_VALUE = 2000;
    private final ItemStack recipeFertilizerOutputApatite;
    private final ItemStack recipeFertilizerOutputAsh;
    private final ItemStack recipeCompostOutputWheat;
    private final ItemStack recipeCompostOutputAsh;
    private final ItemStack recipeHumusOutputFertilizer;
    private final ItemStack recipeHumusOutputCompost;
    private final ItemStack recipeBogEarthOutputBucket;
    private final ItemStack recipeBogEarthOutputCans;
    private final ItemStack recipeCanOutput;
    private final ItemStack recipeCapsuleOutput;
    private final ItemStack recipeRefractoryOutput;
    private static final int FERMENTATION_DURATION_FERTILIZER = 200;
    private static final int FERMENTATION_DURATION_COMPOST = 250;
    private static final int FERMENTED_CYCLE_FERTILIZER = 56;
    private static final int FERMENTED_CYCLE_COMPOST = 48;
    private static final int FERMENTED_SAPLING = 250;
    private static final int FERMENTED_CACTI = 50;
    private static final int FERMENTED_WHEAT = 50;
    private static final int FERMENTED_CANE = 50;
    private static final int FERMENTED_MUSHROOM = 50;
    private static final int SQUEEZED_LIQUID_SEED = 10;
    private static final int SQUEEZED_LIQUID_APPLE = 200;
    private static final int SQUEEZED_MULCH_APPLE = 20;

    public GameMode(String identifier) {
        this.recipeFertilizerOutputApatite = PluginCore.items.fertilizerCompound.getItemStack(8);
        this.recipeFertilizerOutputAsh = PluginCore.items.fertilizerCompound.getItemStack(16);
        this.recipeCompostOutputWheat = PluginCore.items.fertilizerBio.getItemStack(4);
        this.recipeCompostOutputAsh = PluginCore.items.fertilizerBio.getItemStack(1);
        this.recipeHumusOutputFertilizer = PluginCore.blocks.soil.get(BlockSoil.SoilType.HUMUS, 8);
        this.recipeHumusOutputCompost = PluginCore.blocks.soil.get(BlockSoil.SoilType.HUMUS, 8);
        this.recipeBogEarthOutputBucket = PluginCore.blocks.soil.get(BlockSoil.SoilType.BOG_EARTH, 6);
        this.recipeBogEarthOutputCans = PluginCore.blocks.soil.get(BlockSoil.SoilType.BOG_EARTH, 8);
        this.recipeCanOutput = PluginFluids.items.canEmpty.getItemStack(12);
        this.recipeCapsuleOutput = PluginFluids.items.waxCapsuleEmpty.getItemStack(4);
        this.recipeRefractoryOutput = PluginFluids.items.refractoryEmpty.getItemStack(4);
        this.identifier = identifier;
        this.category = "gamemodes/" + identifier;
        File configFile = new File(Forestry.instance.getConfigFolder(), this.category + ".cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        this.initSettingFloat(config, "energy", "demand.modifier", 1.0f);
        this.initSettingBoolean(config, "energy", "engine.clockwork", true);
        this.initSettingInt(config, "farms", "fertilizer.value", 2000);
        this.initSettingFloat(config, "fuel.ethanol", "generator", 1.0f);
        this.initSettingFloat(config, "fuel.ethanol", "combustion", 1.0f);
        this.initSettingFloat(config, "fuel.biomass", "generator", 1.0f);
        this.initSettingFloat(config, "fuel.biomass", "biogas", 1.0f);
        this.initSettingStack(config, "recipe.output.fertilizer", "apatite", this.recipeFertilizerOutputApatite);
        this.initSettingStack(config, "recipe.output.fertilizer", "ash", this.recipeFertilizerOutputAsh);
        this.initSettingStack(config, "recipe.output.compost", "wheat", this.recipeCompostOutputWheat);
        this.initSettingStack(config, "recipe.output.compost", "ash", this.recipeCompostOutputAsh);
        this.initSettingStack(config, "recipe.output.humus", "fertilizer", this.recipeHumusOutputFertilizer);
        this.initSettingStack(config, "recipe.output.humus", "compost", this.recipeHumusOutputCompost);
        this.initSettingStack(config, "recipe.output.bogearth", "bucket", this.recipeBogEarthOutputBucket);
        this.initSettingStack(config, "recipe.output.bogearth", "can", this.recipeBogEarthOutputCans);
        this.initSettingStack(config, "recipe.output", "can", this.recipeCanOutput);
        this.initSettingStack(config, "recipe.output", "capsule", this.recipeCapsuleOutput);
        this.initSettingStack(config, "recipe.output", "refractory", this.recipeRefractoryOutput);
        this.initSettingInt(config, "fermenter.cycles", "fertilizer", 200);
        this.initSettingInt(config, "fermenter.cycles", "compost", 250);
        this.initSettingInt(config, "fermenter.value", "fertilizer", 56);
        this.initSettingInt(config, "fermenter.value", "compost", 48);
        this.initSettingInt(config, "fermenter.yield", "sapling", 250);
        this.initSettingInt(config, "fermenter.yield", "cactus", 50);
        this.initSettingInt(config, "fermenter.yield", "wheat", 50);
        this.initSettingInt(config, "fermenter.yield", "cane", 50);
        this.initSettingInt(config, "fermenter.yield", "mushroom", 50);
        this.initSettingInt(config, "squeezer.liquid", "seed", 10);
        this.initSettingInt(config, "squeezer.liquid", "apple", 200);
        this.initSettingInt(config, "squeezer.mulch", "apple", 20);
        config.save();
    }

    private void initSettingFloat(LocalizedConfiguration config, String category, String name, float defaultValue) {
        String fullName = category + '.' + name;
        float floatValue = config.getFloatLocalized("gamemode." + category, name, defaultValue, 0.0f, 10.0f);
        this.floatSettings.put(fullName, Float.valueOf(floatValue));
    }

    private void initSettingInt(LocalizedConfiguration config, String category, String key, int defaultValue) {
        String fullKey = category + '.' + key;
        int intValue = config.getIntLocalized("gamemode." + category, key, defaultValue, 0, 2000);
        this.integerSettings.put(fullKey, intValue);
    }

    private void initSettingStack(LocalizedConfiguration config, String category, String key, ItemStack defaultValue) {
        String fullKey = category + '.' + key;
        int stackSize = config.getIntLocalized("gamemode." + category, key, defaultValue.field_77994_a, 0, 64);
        ItemStack changed = defaultValue.func_77946_l();
        changed.field_77994_a = stackSize;
        this.stackSettings.put(fullKey, changed);
    }

    private void initSettingBoolean(LocalizedConfiguration config, String category, String key, boolean defaultValue) {
        String fullKey = category + '.' + key;
        boolean booleanValue = config.getBooleanLocalized("gamemode." + category, key, defaultValue);
        this.booleanSettings.put(fullKey, booleanValue);
    }

    @Override
    public int getIntegerSetting(String ident) {
        if (this.integerSettings.containsKey(ident)) {
            return this.integerSettings.get(ident);
        }
        Log.warning("No such setting: " + ident);
        return -1;
    }

    @Override
    public float getFloatSetting(String ident) {
        if (this.floatSettings.containsKey(ident)) {
            return this.floatSettings.get(ident).floatValue();
        }
        Log.warning("No such setting: " + ident);
        return 1.0f;
    }

    @Override
    public boolean getBooleanSetting(String ident) {
        if (this.booleanSettings.containsKey(ident)) {
            return this.booleanSettings.get(ident);
        }
        Log.warning("No such setting: " + ident);
        return false;
    }

    @Override
    public ItemStack getStackSetting(String ident) {
        if (this.stackSettings.containsKey(ident)) {
            return this.stackSettings.get(ident);
        }
        Log.warning("No such setting: " + ident);
        return new ItemStack(Items.field_151034_e, 1);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

