/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.IContainerSocketed;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class SocketWidget
extends Widget {
    private final ISocketable tile;
    private final int slot;
    private final ToolTip toolTip = new ToolTip(250){

        @Override
        public void refresh() {
            SocketWidget.this.toolTip.clear();
            ItemStack stack = SocketWidget.this.tile.getSocket(SocketWidget.this.slot);
            if (stack != null) {
                EntityClientPlayerMP player = Proxies.common.getClientInstance().field_71439_g;
                SocketWidget.this.toolTip.add(stack.func_82840_a((EntityPlayer)player, false));
                SocketWidget.this.toolTip.add(EnumChatFormatting.ITALIC + StringUtil.localize("gui.socket.remove"));
            } else {
                SocketWidget.this.toolTip.add(StringUtil.localize("gui.emptysocket"));
            }
        }
    };

    public SocketWidget(WidgetManager manager, int xPos, int yPos, ISocketable tile, int slot) {
        super(manager, xPos, yPos);
        this.tile = tile;
        this.slot = slot;
    }

    @Override
    public void draw(int startX, int startY) {
        ItemStack socketStack = this.tile.getSocket(this.slot);
        if (socketStack != null) {
            GuiForestry.getItemRenderer().func_77015_a(this.manager.minecraft.field_71466_p, this.manager.minecraft.field_71446_o, socketStack, startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTip;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        Container container = this.manager.gui.field_147002_h;
        if (!(container instanceof IContainerSocketed)) {
            return;
        }
        IContainerSocketed containerSocketed = (IContainerSocketed)container;
        if (held instanceof ItemCircuitBoard) {
            containerSocketed.handleChipsetClick(this.slot);
        } else if (held instanceof ISolderingIron) {
            containerSocketed.handleSolderingIronClick(this.slot);
        }
    }
}

