/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdClient;
import forestry.core.network.PacketIdServer;
import forestry.core.proxy.Proxies;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class PacketHandler {
    public static final String channelId = "FOR";
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("FOR");

    public PacketHandler() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        DataInputStreamForestry data = PacketHandler.getStream(event.packet);
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            byte packetIdOrdinal = data.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            IForestryPacketServer packetHandler = packetId.getPacketHandler();
            packetHandler.readData(data);
            packetHandler.onPacketData(data, player);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        DataInputStreamForestry data = PacketHandler.getStream(event.packet);
        EntityPlayer player = Proxies.common.getPlayer();
        try {
            byte packetIdOrdinal = data.readByte();
            PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
            IForestryPacketClient packetHandler = packetId.getPacketHandler();
            packetHandler.readData(data);
            packetHandler.onPacketData(data, player);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static DataInputStreamForestry getStream(FMLProxyPacket fmlPacket) {
        ByteBufInputStream is = new ByteBufInputStream(fmlPacket.payload());
        return new DataInputStreamForestry((InputStream)is);
    }

    public void sendPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(packet, player);
    }
}

