/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketNBT;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class PacketGenomeTrackerSync
extends PacketNBT
implements IForestryPacketClient {
    public PacketGenomeTrackerSync() {
    }

    public PacketGenomeTrackerSync(NBTTagCompound nbtTagCompound) {
        super(nbtTagCompound);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        IBreedingTracker tracker = null;
        String type = this.getTagCompound().func_74779_i("TYPE");
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(type);
        if (root != null) {
            tracker = root.getBreedingTracker(Proxies.common.getRenderWorld(), player.func_146103_bH());
        }
        if (tracker != null) {
            tracker.decodeFromNBT(this.getTagCompound());
            MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.GENOME_TRACKER_UPDATE;
    }
}

