/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.amazingtrophies;

import WayofTime.alchemicalWizardry.ModItems;
import com.dreammaster.main.MainRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import fox.spiteful.avaritia.DamageSourceInfinitySword;
import fox.spiteful.avaritia.items.LudicrousItems;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsFile;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import tconstruct.library.tools.ToolCore;

public class AchievementHandler {
    private static final Map<UUID, Integer> LAST_DEATHCOUNT = new HashMap<UUID, Integer>();
    private static final Map<UUID, Float> LAST_DAMAGE = new HashMap<UUID, Float>();
    private static StatBase infinityArmorAchievement;
    private static StatBase omegaArmorAchievement;
    private static StatBase damageAchievement;
    public static StatBase eternityBeaconAchievement;
    private static StatBase allEffects;
    private static StatBase hearts;
    private static StatBase unbreakableTool;
    private static int numberPotions;

    public static void init() {
        infinityArmorAchievement = StatList.func_151177_a((String)"infinity_armor");
        omegaArmorAchievement = StatList.func_151177_a((String)"omega_armor");
        damageAchievement = StatList.func_151177_a((String)"10k_damage");
        eternityBeaconAchievement = StatList.func_151177_a((String)"eternity_beacon");
        allEffects = StatList.func_151177_a((String)"all_effects");
        hearts = StatList.func_151177_a((String)"100_hearts");
        unbreakableTool = StatList.func_151177_a((String)"unbreakable_tconstruct_tool");
        for (Potion potion : Potion.field_76425_a) {
            if (potion == null || potion.func_76403_b()) continue;
            ++numberPotions;
        }
    }

    public static void cleanup() {
        LAST_DAMAGE.clear();
        LAST_DEATHCOUNT.clear();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack[] armor;
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        UUID uuid = player.func_110124_au();
        StatisticsFile statFile = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152602_a(player);
        if (statFile == null) {
            MainRegistry.Logger.warn((Object)String.format("Failed to get statistics file for player %s (UUID: %s) during PlayerTickEvent.", player.func_70005_c_(), uuid));
            return;
        }
        int currentDeathCount = statFile.func_77444_a(StatList.field_75960_y);
        Float lastDamage = LAST_DAMAGE.get(uuid);
        if (lastDamage != null && lastDamage.floatValue() >= 10000.0f && LAST_DEATHCOUNT.get(uuid) == currentDeathCount) {
            player.func_71029_a(damageAchievement);
        }
        if (player.func_70651_bq().size() == numberPotions) {
            player.func_71029_a(allEffects);
        }
        if (player.func_110138_aP() >= 200.0f) {
            player.func_71029_a(hearts);
        }
        if (AchievementHandler.hasArmor(armor = player.field_71071_by.field_70460_b, LudicrousItems.infinity_helm, LudicrousItems.infinity_armor, LudicrousItems.infinity_pants, LudicrousItems.infinity_shoes)) {
            player.func_71029_a(infinityArmorAchievement);
            return;
        }
        if (AchievementHandler.hasArmor(armor, ModItems.boundHelmetEarth, ModItems.boundPlateEarth, ModItems.boundLeggingsEarth, ModItems.boundBootsEarth) || AchievementHandler.hasArmor(armor, ModItems.boundHelmetFire, ModItems.boundPlateFire, ModItems.boundLeggingsFire, ModItems.boundBootsFire) || AchievementHandler.hasArmor(armor, ModItems.boundHelmetWater, ModItems.boundPlateWater, ModItems.boundLeggingsWater, ModItems.boundBootsWater) || AchievementHandler.hasArmor(armor, ModItems.boundHelmetWind, ModItems.boundPlateWind, ModItems.boundLeggingsWind, ModItems.boundBootsWind)) {
            player.func_71029_a(omegaArmorAchievement);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onLivingAttack(LivingAttackEvent event) {
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLivingBase;
        UUID uuid = player.func_110124_au();
        StatisticsFile statFile = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152602_a(player);
        if (statFile == null) {
            MainRegistry.Logger.warn((Object)String.format("Failed to get statistics file for player %s (UUID: %s) during LivingAttackEvent.", player.func_70005_c_(), uuid));
            return;
        }
        int deathCount = statFile.func_77444_a(StatList.field_75960_y);
        float amount = event.source instanceof DamageSourceInfinitySword ? Float.POSITIVE_INFINITY : event.ammount;
        LAST_DEATHCOUNT.put(uuid, deathCount);
        LAST_DAMAGE.put(uuid, Float.valueOf(amount));
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack stack = event.pickedUp.func_92059_d();
        if (stack.func_77973_b() instanceof ToolCore && stack.func_77942_o() && stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Unbreaking") >= 10) {
            event.player.func_71029_a(unbreakableTool);
        }
    }

    private static boolean hasArmor(ItemStack[] armor, Item helmet, Item chestplate, Item leggins, Item boots) {
        ItemStack equippedHelmet = armor[3];
        ItemStack equippedChestplate = armor[2];
        ItemStack equippedLeggins = armor[1];
        ItemStack equippedBoots = armor[0];
        if (equippedHelmet == null || equippedChestplate == null || equippedLeggins == null || equippedBoots == null) {
            return false;
        }
        return equippedHelmet.func_77973_b() == helmet && equippedChestplate.func_77973_b() == chestplate && equippedLeggins.func_77973_b() == leggins && equippedBoots.func_77973_b() == boots;
    }

    static {
        numberPotions = 0;
    }
}

