/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipeConstants;
import gttweaker.mods.AddMultipleRecipeAction;
import gttweaker.util.ArrayHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.BlastFurnace")
@ModOnly(value={"gregtech"})
public class BlastFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, ILiquidStack fluidOutput, IIngredient[] input, ILiquidStack fluidInput, int durationTicks, int euPerTick, int heat) {
        if (output.length == 0 || input.length == 0) {
            MineTweakerAPI.logError((String)"Blast furnace recipe requires at least 1 input and 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Blast furnace recipe for " + output[0], new Object[]{input[0], ArrayHelper.itemOrNull(input, 1), fluidInput, fluidOutput, output[0], ArrayHelper.itemOrNull(output, 1), durationTicks, euPerTick, heat}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input1 = i.nextItem();
                    ItemStack input2 = i.nextItem();
                    ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(input1, input2));
                    inputs.removeIf(Objects::isNull);
                    FluidStack fluidInput = i.nextFluid();
                    FluidStack fluidOutput = i.nextFluid();
                    ItemStack output1 = i.nextItem();
                    ItemStack output2 = i.nextItem();
                    ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(Arrays.asList(output1, output2));
                    outputs.removeIf(Objects::isNull);
                    int duration = i.nextInt();
                    int eut = i.nextInt();
                    int heatLevel = i.nextInt();
                    GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).itemOutputs(outputs.toArray(new ItemStack[0])).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(new FluidStack[]{fluidOutput}).metadata(GTRecipeConstants.COIL_HEAT, (Object)heatLevel).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
                }
            });
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, ILiquidStack fluidInput, IIngredient[] input, int durationTicks, int euPerTick, int heat) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Blast furnace recipe for " + output[0], new Object[]{input[0], ArrayHelper.itemOrNull(input, 1), fluidInput, output[0], ArrayHelper.itemOrNull(output, 1), durationTicks, euPerTick, heat}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                ItemStack input1 = i.nextItem();
                ItemStack input2 = i.nextItem();
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(input1, input2));
                inputs.removeIf(Objects::isNull);
                FluidStack fluidInput = i.nextFluid();
                ItemStack output1 = i.nextItem();
                ItemStack output2 = i.nextItem();
                ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(Arrays.asList(output1, output2));
                outputs.removeIf(Objects::isNull);
                int duration = i.nextInt();
                int eut = i.nextInt();
                int heatLevel = i.nextInt();
                GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).itemOutputs(outputs.toArray(new ItemStack[0])).fluidInputs(new FluidStack[]{fluidInput}).metadata(GTRecipeConstants.COIL_HEAT, (Object)heatLevel).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
            }
        });
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient[] input, int durationTicks, int euPerTick, int heat) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Blast furnace recipe for " + output[0], new Object[]{input[0], ArrayHelper.itemOrNull(input, 1), output[0], ArrayHelper.itemOrNull(output, 1), durationTicks, euPerTick, heat}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                ItemStack input1 = i.nextItem();
                ItemStack input2 = i.nextItem();
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(input1, input2));
                inputs.removeIf(Objects::isNull);
                ItemStack output1 = i.nextItem();
                ItemStack output2 = i.nextItem();
                ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(Arrays.asList(output1, output2));
                outputs.removeIf(Objects::isNull);
                int duration = i.nextInt();
                int eut = i.nextInt();
                int heatLevel = i.nextInt();
                GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).itemOutputs(outputs.toArray(new ItemStack[0])).metadata(GTRecipeConstants.COIL_HEAT, (Object)heatLevel).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
            }
        });
    }
}

