/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.capes;

import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.client.capes.GCCapesEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public class GCCapeLoader
implements Runnable {
    private static final ResourceLocation CAPE_BLUE = new ResourceLocation("galacticraftcore:textures/capes/capeBlue.png");
    private static final ResourceLocation CAPE_BROWN = new ResourceLocation("galacticraftcore:textures/capes/capeBrown.png");
    private static final ResourceLocation CAPE_CYAN = new ResourceLocation("galacticraftcore:textures/capes/capeCyan.png");
    private static final ResourceLocation CAPE_DARK_GRAY = new ResourceLocation("galacticraftcore:textures/capes/capeDarkGray.png");
    private static final ResourceLocation CAPE_DARK_GREEN = new ResourceLocation("galacticraftcore:textures/capes/capeDarkGreen.png");
    private static final ResourceLocation CAPE_LIGHT_BLUE = new ResourceLocation("galacticraftcore:textures/capes/capeLightBlue.png");
    private static final ResourceLocation CAPE_LIGHT_GRAY = new ResourceLocation("galacticraftcore:textures/capes/capeLightGray.png");
    private static final ResourceLocation CAPE_LIME = new ResourceLocation("galacticraftcore:textures/capes/capeLime.png");
    private static final ResourceLocation CAPE_MAGENTA = new ResourceLocation("galacticraftcore:textures/capes/capeMagenta.png");
    private static final ResourceLocation CAPE_ORANGE = new ResourceLocation("galacticraftcore:textures/capes/capeOrange.png");
    private static final ResourceLocation CAPE_PINK = new ResourceLocation("galacticraftcore:textures/capes/capePink.png");
    private static final ResourceLocation CAPE_PURPLE = new ResourceLocation("galacticraftcore:textures/capes/capePurple.png");
    private static final ResourceLocation CAPE_RAINBOW = new ResourceLocation("galacticraftcore:textures/capes/capeRainbow.png");
    private static final ResourceLocation CAPE_RED = new ResourceLocation("galacticraftcore:textures/capes/capeRed.png");
    private static final ResourceLocation CAPE_YELLOW = new ResourceLocation("galacticraftcore:textures/capes/capeYellow.png");

    @Override
    public void run() {
        Map<String, ResourceLocation> nameToCape = GCCapeLoader.loadNameToCapeMap();
        if (!nameToCape.isEmpty()) {
            Minecraft.func_71410_x().func_152343_a(() -> {
                MinecraftForge.EVENT_BUS.register((Object)new GCCapesEventHandler(nameToCape));
                return null;
            });
        }
    }

    private static Map<String, ResourceLocation> loadNameToCapeMap() {
        InputStream stream;
        URLConnection connection;
        URL capeListUrl;
        HashMap<String, ResourceLocation> nameToCape = new HashMap<String, ResourceLocation>();
        int timeout = 10000;
        try {
            capeListUrl = new URL("https://raw.github.com/micdoodle8/Galacticraft/master/capes.txt");
        }
        catch (MalformedURLException e) {
            FMLLog.severe((String)"Error getting capes list URL", (Object[])new Object[0]);
            e.printStackTrace();
            return nameToCape;
        }
        try {
            connection = capeListUrl.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return nameToCape;
        }
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        try {
            stream = connection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return nameToCape;
        }
        InputStreamReader streamReader = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(streamReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(":")) continue;
                int splitLocation = line.indexOf(":");
                String username = line.substring(0, splitLocation);
                String capeName = line.substring(splitLocation + 1);
                nameToCape.put(username, GCCapeLoader.capeFromString(capeName));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            streamReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nameToCape;
    }

    private static ResourceLocation capeFromString(String capeName) {
        ResourceLocation resourceLocation;
        switch (capeName) {
            case "capeBrown": {
                resourceLocation = CAPE_BROWN;
                break;
            }
            case "capeCyan": {
                resourceLocation = CAPE_CYAN;
                break;
            }
            case "capeDarkGray": {
                resourceLocation = CAPE_DARK_GRAY;
                break;
            }
            case "capeDarkGreen": {
                resourceLocation = CAPE_DARK_GREEN;
                break;
            }
            case "capeLightBlue": {
                resourceLocation = CAPE_LIGHT_BLUE;
                break;
            }
            case "capeLightGray": {
                resourceLocation = CAPE_LIGHT_GRAY;
                break;
            }
            case "capeLime": {
                resourceLocation = CAPE_LIME;
                break;
            }
            case "capeMagenta": {
                resourceLocation = CAPE_MAGENTA;
                break;
            }
            case "capeOrange": {
                resourceLocation = CAPE_ORANGE;
                break;
            }
            case "capePink": {
                resourceLocation = CAPE_PINK;
                break;
            }
            case "capePurple": {
                resourceLocation = CAPE_PURPLE;
                break;
            }
            case "capeRainbow": {
                resourceLocation = CAPE_RAINBOW;
                break;
            }
            case "capeRed": {
                resourceLocation = CAPE_RED;
                break;
            }
            case "capeYellow": {
                resourceLocation = CAPE_YELLOW;
                break;
            }
            default: {
                resourceLocation = CAPE_BLUE;
            }
        }
        return resourceLocation;
    }
}

