/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.modifiers;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.reference.Config;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import tconstruct.modifiers.tools.ModBoolean;

public class ModMiningLevelBoost
extends ModBoolean {
    private int maxLvl = 0;

    public ModMiningLevelBoost(ItemStack[] recipe, int effect, int maxLvl) {
        super(recipe, effect, "Mining Level Boost", EnumChatFormatting.GREEN.toString(), recipe[0].func_82833_r());
        this.maxLvl = maxLvl;
    }

    protected boolean canModify(ItemStack input, ItemStack[] recipe) {
        NBTTagCompound tags = input.func_77978_p().func_74775_l("InfiTool");
        if (Config.mobHeadRequiresModifier && tags.func_74762_e("Modifiers") <= 0) {
            return false;
        }
        if (tags.func_74767_n(this.key)) {
            return false;
        }
        int hlvl = tags.func_74762_e("HarvestLevel");
        return hlvl < this.maxLvl && LevelingLogic.canBoostMiningLevel(tags);
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        LevelingLogic.levelUpMiningLevel(tool, null, false);
        if (!Config.mobHeadRequiresModifier) {
            NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
            tags.func_74768_a("Modifiers", tags.func_74762_e("Modifiers") + 1);
        }
        super.modify(input, tool);
    }
}

