/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.override;

import iguanaman.iguanatweakstconstruct.harvestlevels.HarvestLevelTweaks;
import iguanaman.iguanatweakstconstruct.override.IOverride;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ToolOverride
implements IOverride {
    @Override
    public void createDefault(Configuration config) {
        Log.debug("Creating Tool Default File");
        for (Object identifier : Item.field_150901_e.func_148742_b()) {
            Object o = Item.field_150901_e.func_82594_a(identifier);
            if (!(o instanceof Item) || o instanceof ItemBlock) continue;
            Item item = (Item)o;
            ItemStack stack = new ItemStack(item);
            String saneCategory = this.buildCategory(identifier.toString());
            for (String tool : item.getToolClasses(stack)) {
                int level = item.getHarvestLevel(stack, tool);
                config.get(saneCategory, tool, level).getInt();
            }
        }
    }

    @Override
    public void processConfig(Configuration config) {
        Log.debug("Loading Tool Overrides");
        StringBuilder comment = new StringBuilder();
        comment.append("Copy the desired tools you want to change from the defaults file into this file and adapt the stats.\n\n");
        comment.append("Mining Levels:\n");
        for (int i = 0; i <= HarvestLevels.max; ++i) {
            comment.append(String.format("\t%d - %s\n", i, HarvestLevels.getHarvestLevelName(i)));
        }
        config.setCategoryComment(" Info", comment.toString());
        Property prop = config.get(" Info", "fillWithDefault", false, "Fills this file with the default values, not altering changed values.");
        boolean fillWithDefault = prop.getBoolean();
        prop.set(false);
        prop = config.get(" Info", "removeDefaultValues", false, "Removes all entries that correspond to the default values.");
        boolean cleanup = prop.getBoolean();
        prop.set(false);
        for (Object identifier : Item.field_150901_e.func_148742_b()) {
            String saneCategory;
            Object o = Item.field_150901_e.func_82594_a(identifier);
            if (!(o instanceof Item) || o instanceof ItemBlock || !config.hasCategory(saneCategory = this.buildCategory(identifier.toString())) && !fillWithDefault) continue;
            Item item = (Item)o;
            ItemStack stack = new ItemStack(item);
            boolean changed = false;
            for (String tool : item.getToolClasses(stack)) {
                int newLevel;
                int level = item.getHarvestLevel(stack, tool);
                if (level == (newLevel = (prop = config.get(saneCategory, tool, level)).getInt())) continue;
                HarvestLevelTweaks.updateToolHarvestLevel(item, tool, newLevel);
                if (Config.logOverrideChanges) {
                    Log.info(String.format("Tool Override: Changed harvest level of %s to %d", item.func_77658_a(), newLevel));
                }
                changed = true;
            }
            if (changed || !cleanup) continue;
            config.removeCategory(config.getCategory(saneCategory));
        }
    }

    private String buildCategory(String identifier) {
        String cat = identifier.replace(".", "_");
        return cat.replaceFirst(":", ".").toLowerCase();
    }
}

