/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.text;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.github.lunatrius.ingameinfo.parser.text.AlignmentException;
import com.github.lunatrius.ingameinfo.parser.text.Token;
import com.github.lunatrius.ingameinfo.parser.text.Tokenizer;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.value.Value;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TextParser
implements IParser {
    private final Tokenizer tokenizer;
    private Token token;
    private int level = 0;
    private Alignment alignment = Alignment.TOPLEFT;

    public TextParser() {
        this.tokenizer = new Tokenizer();
    }

    private Token nextToken() {
        this.token = this.tokenizer.nextToken();
        return this.token;
    }

    @Override
    public boolean load(InputStream inputStream) {
        try {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
            reader.close();
            inputStreamReader.close();
            this.tokenizer.tokenize(content.toString());
        }
        catch (Exception e) {
            Reference.logger.fatal("Could not read text configuration file!", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean parse(Map<Alignment, List<List<Value>>> format) {
        boolean expr;
        try {
            this.nextToken();
            expr = this.alignments(format) && this.token.isEof();
        }
        catch (Exception e) {
            expr = false;
            Reference.logger.error("Parsing failed!", (Throwable)e);
        }
        return expr;
    }

    private boolean alignments(Map<Alignment, List<List<Value>>> format) {
        return this.alignment(format) && this.alignmentsTail(format);
    }

    private boolean alignmentsTail(Map<Alignment, List<List<Value>>> format) {
        if (this.alignment(format)) {
            this.alignmentsTail(format);
        }
        return true;
    }

    private boolean alignment(Map<Alignment, List<List<Value>>> format) {
        boolean expr;
        List<List<Value>> lines = format.get((Object)this.alignment);
        if (lines == null) {
            lines = new ArrayList<List<Value>>();
        }
        try {
            expr = this.lines(lines);
            if (expr) {
                format.put(this.alignment, lines);
            }
        }
        catch (AlignmentException e) {
            format.put(this.alignment, lines);
            this.alignment = e.getAlignment();
            expr = e.isValid();
        }
        return expr;
    }

    private boolean lines(List<List<Value>> lines) throws AlignmentException {
        return this.line(lines) && this.linesTail(lines);
    }

    private boolean linesTail(List<List<Value>> lines) throws AlignmentException {
        if (this.line(lines)) {
            this.linesTail(lines);
        }
        return true;
    }

    private boolean line(List<List<Value>> lines) throws AlignmentException {
        ArrayList<Value> values = new ArrayList<Value>();
        boolean expr = this.values(values);
        if (this.token.getType().equals((Object)Token.TokenType.NEWLINE)) {
            this.nextToken();
        }
        if (expr) {
            lines.add(values);
        }
        return expr;
    }

    private boolean values(List<Value> values) throws AlignmentException {
        return this.value(values) && this.valuesTail(values);
    }

    private boolean valuesTail(List<Value> values) throws AlignmentException {
        if (this.value(values)) {
            this.valuesTail(values);
        }
        return true;
    }

    private boolean value(List<Value> values) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.STRING)) {
            expr = this.string(values, this.token.getLexem());
            this.nextToken();
        } else if (this.token.getType().equals((Object)Token.TokenType.FUNC_HEAD)) {
            this.nextToken();
            expr = this.function(values, this.token.getLexem());
        } else if (this.level == 0 && Token.TokenType.EXCEPTIONS.contains((Object)this.token.getType())) {
            expr = this.string(values, this.token.getLexem());
            this.nextToken();
        } else {
            expr = false;
        }
        return expr;
    }

    private boolean string(List<Value> values, String lexem) {
        Value value = Value.fromString("str").setRawValue(lexem, true);
        values.add(value);
        return true;
    }

    private boolean function(List<Value> values, String lexem) throws AlignmentException {
        boolean expr;
        ++this.level;
        Value value = Value.fromString(lexem);
        if (!value.isValid()) {
            value = Value.fromString("var");
            value.setRawValue(lexem, true);
        } else {
            value.setRawValue("", true);
        }
        if (this.token.getType().equals((Object)Token.TokenType.STRING)) {
            this.nextToken();
            expr = this.argumentGroupA(value);
            if (this.token.getType().equals((Object)Token.TokenType.FUNC_TAIL)) {
                this.nextToken();
            } else {
                expr = false;
            }
        } else {
            expr = false;
        }
        --this.level;
        Alignment alignment = Alignment.parse(lexem);
        if (alignment != null) {
            throw new AlignmentException(alignment, expr);
        }
        if (expr) {
            values.add(value);
        }
        return expr;
    }

    private boolean argumentGroupA(Value value) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_HEAD)) {
            this.nextToken();
            expr = this.argumentsA(value);
            expr &= this.argumentGroupB(value);
            if (this.token.getType().equals((Object)Token.TokenType.ARGS_TAIL)) {
                this.nextToken();
            } else {
                expr = false;
            }
        } else {
            expr = true;
        }
        return expr;
    }

    private boolean argumentsA(Value value) throws AlignmentException {
        return this.argument(value) && this.argumentsATail(value);
    }

    private boolean argumentsATail(Value value) throws AlignmentException {
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_SEPARATOR)) {
            this.nextToken();
            if (this.argument(value)) {
                this.argumentsATail(value);
            }
        }
        return true;
    }

    private boolean argument(Value value) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.STRING)) {
            expr = this.string(value.values, this.token.getLexem());
            this.nextToken();
        } else if (this.token.getType().equals((Object)Token.TokenType.FUNC_HEAD)) {
            this.nextToken();
            expr = this.function(value.values, this.token.getLexem());
        } else {
            expr = this.string(value.values, "");
        }
        return expr;
    }

    private boolean argumentGroupB(Value value) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_HEAD)) {
            this.nextToken();
            expr = this.argumentsB(value);
            if (this.token.getType().equals((Object)Token.TokenType.ARGS_TAIL)) {
                this.nextToken();
            } else {
                expr = false;
            }
        } else {
            expr = true;
        }
        return expr;
    }

    private boolean argumentsB(Value value) throws AlignmentException {
        return this.argument(value) && this.argumentsBTail(value);
    }

    private boolean argumentsBTail(Value value) throws AlignmentException {
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_SEPARATOR)) {
            this.nextToken();
            if (this.argument(value)) {
                this.argumentsBTail(value);
            }
        }
        return true;
    }
}

