/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.client.RendererBossGlow;
import atomicstryker.infernalmobs.common.ISidedProxy;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.modifiers.MM_Gravity;
import atomicstryker.infernalmobs.common.modifiers.MobModifier;
import atomicstryker.infernalmobs.common.network.packets.HealthPacket;
import atomicstryker.infernalmobs.common.network.packets.MobModsPacket;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.lwjgl.opengl.GL11;

public class InfernalMobsClient
implements ISidedProxy {
    private static final double NAME_VISION_DISTANCE = 32.0;
    private Minecraft mc;
    private long nextPacketTime;
    private ConcurrentHashMap<EntityLivingBase, MobModifier> rareMobsClient;
    private int airOverrideValue = -999;
    private long airDisplayTimeout;
    private long healthBarRetainTime;
    private EntityLivingBase retainedTarget;

    @Override
    public void preInit() {
        FMLCommonHandler.instance().bus().register((Object)this);
        this.mc = FMLClientHandler.instance().getClient();
    }

    @Override
    public void load() {
        this.nextPacketTime = 0L;
        this.rareMobsClient = new ConcurrentHashMap();
        MinecraftForge.EVENT_BUS.register((Object)new RendererBossGlow());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.healthBarRetainTime = 0L;
        this.retainedTarget = null;
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K && this.mc.field_71439_g != null && (event.entity instanceof EntityMob || event.entity instanceof EntityLivingBase && event.entity instanceof IMob)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(this.mc.field_71439_g.func_146103_bH().getName(), event.entity.func_145782_y(), 0));
        }
    }

    private void askServerHealth(Entity ent) {
        if (System.currentTimeMillis() > this.nextPacketTime) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new HealthPacket(this.mc.field_71439_g.func_146103_bH().getName(), ent.func_145782_y(), 0.0f, 0.0f));
            this.nextPacketTime = System.currentTimeMillis() + 100L;
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        MobModifier mod;
        if (InfernalMobsCore.instance().getIsHealthBarDisabled() || event.type != RenderGameOverlayEvent.ElementType.BOSSHEALTH || BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0) {
            return;
        }
        Entity ent = this.getEntityCrosshairOver(event.partialTicks, this.mc);
        boolean retained = false;
        if (ent == null && System.currentTimeMillis() < this.healthBarRetainTime) {
            ent = this.retainedTarget;
            retained = true;
        }
        if (ent instanceof EntityLivingBase && (mod = InfernalMobsCore.getMobModifiers((EntityLivingBase)ent)) != null) {
            this.askServerHealth(ent);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            GL11.glDisable((int)3042);
            EntityLivingBase target = (EntityLivingBase)ent;
            String buffer = mod.getEntityDisplayName(target);
            int screenwidth = event.resolution.func_78326_a();
            FontRenderer fontR = this.mc.field_71466_p;
            GuiIngame gui = this.mc.field_71456_v;
            int lifeBarLength = 182;
            int x = screenwidth / 2 - lifeBarLength / 2;
            int lifeBarLeft = (int)(mod.getActualHealth(target) / mod.getActualMaxHealth(target) * (float)(lifeBarLength + 1));
            int y = 12;
            gui.func_73729_b(x, y, 0, 74, lifeBarLength, 5);
            if (lifeBarLeft > 0) {
                gui.func_73729_b(x, y, 0, 79, lifeBarLeft, 5);
            }
            int yCoord = 1;
            fontR.func_78261_a(buffer, screenwidth / 2 - fontR.func_78256_a(buffer) / 2, yCoord, 3118827);
            yCoord += 8;
            String[] display = mod.getDisplayNames();
            for (int i = 0; i < display.length && display[i] != null; ++i) {
                fontR.func_78261_a(display[i], screenwidth / 2 - fontR.func_78256_a(display[i]) / 2, yCoord += 10, 0xFFFFFF);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            if (!retained) {
                this.retainedTarget = target;
                this.healthBarRetainTime = System.currentTimeMillis() + 3000L;
            }
        }
    }

    private Entity getEntityCrosshairOver(float renderTick, Minecraft mc) {
        Entity returnedEntity = null;
        if (mc.field_71451_h != null && mc.field_71441_e != null) {
            double reachDistance = 32.0;
            MovingObjectPosition mopos = mc.field_71451_h.func_70614_a(reachDistance, renderTick);
            double reachDist2 = reachDistance;
            Vec3 viewEntPositionVec = mc.field_71451_h.func_70666_h(renderTick);
            if (mopos != null) {
                reachDist2 = mopos.field_72307_f.func_72438_d(viewEntPositionVec);
            }
            Vec3 viewEntityLookVec = mc.field_71451_h.func_70676_i(renderTick);
            Vec3 actualReachVector = viewEntPositionVec.func_72441_c(viewEntityLookVec.field_72450_a * reachDistance, viewEntityLookVec.field_72448_b * reachDistance, viewEntityLookVec.field_72449_c * reachDistance);
            float expandBBvalue = 1.0f;
            double lowestDistance = reachDist2;
            Entity pointedEntity = null;
            for (Object obj : mc.field_71441_e.func_72839_b((Entity)mc.field_71451_h, mc.field_71451_h.field_70121_D.func_72321_a(viewEntityLookVec.field_72450_a * reachDistance, viewEntityLookVec.field_72448_b * reachDistance, viewEntityLookVec.field_72449_c * reachDistance).func_72314_b((double)expandBBvalue, (double)expandBBvalue, (double)expandBBvalue))) {
                double distanceToEnt;
                Entity iterEnt = (Entity)obj;
                if (!iterEnt.func_70067_L()) continue;
                float entBorderSize = iterEnt.func_70111_Y();
                AxisAlignedBB entHitBox = iterEnt.field_70121_D.func_72314_b((double)entBorderSize, (double)entBorderSize, (double)entBorderSize);
                MovingObjectPosition interceptObjectPosition = entHitBox.func_72327_a(viewEntPositionVec, actualReachVector);
                if (entHitBox.func_72318_a(viewEntPositionVec)) {
                    if (!(0.0 < lowestDistance) && lowestDistance != 0.0) continue;
                    pointedEntity = iterEnt;
                    lowestDistance = 0.0;
                    continue;
                }
                if (interceptObjectPosition == null || !((distanceToEnt = viewEntPositionVec.func_72438_d(interceptObjectPosition.field_72307_f)) < lowestDistance) && lowestDistance != 0.0) continue;
                pointedEntity = iterEnt;
                lowestDistance = distanceToEnt;
            }
            if (pointedEntity != null && (lowestDistance < reachDist2 || mopos == null)) {
                returnedEntity = pointedEntity;
            }
        }
        return returnedEntity;
    }

    @Override
    public ConcurrentHashMap<EntityLivingBase, MobModifier> getRareMobs() {
        return this.rareMobsClient;
    }

    @Override
    public void onHealthPacketForClient(String stringData, int entID, float health, float maxhealth) {
        MobModifier mod;
        Entity ent = FMLClientHandler.instance().getClient().field_71441_e.func_73045_a(entID);
        if (ent instanceof EntityLivingBase && (mod = InfernalMobsCore.getMobModifiers((EntityLivingBase)ent)) != null) {
            mod.setActualHealth(health, maxhealth);
        }
    }

    @Override
    public void onKnockBackPacket(float xv, float zv) {
        MM_Gravity.knockBack((EntityLivingBase)FMLClientHandler.instance().getClient().field_71439_g, xv, zv);
    }

    @Override
    public void onMobModsPacketToClient(String stringData, int entID) {
        InfernalMobsCore.instance().addRemoteEntityModifiers((World)FMLClientHandler.instance().getClient().field_71441_e, entID, stringData);
    }

    @Override
    public void onVelocityPacket(float xv, float yv, float zv) {
        FMLClientHandler.instance().getClient().field_71439_g.func_70024_g((double)xv, (double)yv, (double)zv);
    }

    @Override
    public void onAirPacket(int air) {
        this.airOverrideValue = air;
        this.airDisplayTimeout = System.currentTimeMillis() + 3000L;
    }

    @SubscribeEvent
    public void onTick(RenderGameOverlayEvent.Pre event) {
        if (System.currentTimeMillis() > this.airDisplayTimeout) {
            this.airOverrideValue = -999;
        }
        if (event.type == RenderGameOverlayEvent.ElementType.AIR && !this.mc.field_71439_g.func_70055_a(Material.field_151586_h) && this.airOverrideValue != -999) {
            GL11.glEnable((int)3042);
            int right_height = 39;
            int left = event.resolution.func_78326_a() / 2 + 91;
            int top = event.resolution.func_78328_b() - right_height;
            int full = MathHelper.func_76143_f((double)((double)(this.airOverrideValue - 2) * 10.0 / 300.0));
            int partial = MathHelper.func_76143_f((double)((double)this.airOverrideValue * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.mc.field_71456_v.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            GL11.glDisable((int)3042);
        }
    }
}

