/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.ironchestminecarts;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import ganymedes01.ironchestminecarts.gui.GuiHandler;
import ganymedes01.ironchestminecarts.minecarts.EntityMinecartIronChestAbstract;
import ganymedes01.ironchestminecarts.minecarts.ItemMinecartChestRenderer;
import ganymedes01.ironchestminecarts.minecarts.ItemMinecartIronChest;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

@Mod(modid="ironchestminecarts", name="Iron Chest Minecarts", version="1.2.0", dependencies="required-after:Forge@[10.10,);required-after:IronChest")
public class IronChestMinecarts {
    @Mod.Instance(value="ironchestminecarts")
    public static IronChestMinecarts instance;
    public static Map<IronChestType, Item> carts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        boolean renderMinecarts3D = false;
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            renderMinecarts3D = cfg.get("general", "render minecarts in 3D on inventory", renderMinecarts3D, "If set to true minecarts will be rendered in 3D on the player's hand and on inventories").getBoolean(renderMinecarts3D);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Iron Chest Minecarts had a problem loading its configs!", (Object[])new Object[0]);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        OreDictionary.registerOre((String)"chestEnder", (Block)Blocks.field_150477_bB);
        OreDictionary.registerOre((String)"chestTrapped", (Block)Blocks.field_150447_bR);
        OreDictionary.registerOre((String)"chestWood", (Block)Blocks.field_150486_ae);
        for (IronChestType type : EntityMinecartIronChestAbstract.registeredTypes()) {
            String name = type.name().toLowerCase();
            Item minecart = new ItemMinecartIronChest(type).func_77655_b("ironchestminecarts.minecart_chest_" + name).func_111206_d("ironchestminecarts:minecart_chest_" + name.replace("teel", "ilver"));
            GameRegistry.registerItem((Item)minecart, (String)("minecart_chest_" + name));
            carts.put(type, minecart);
            ItemStack chest = new ItemStack((Block)IronChest.ironChestBlock, 1, type.ordinal());
            if (type == IronChestType.DIRTCHEST9000) {
                name = "dirt";
            }
            String ore = "chest" + name.substring(0, 1).toUpperCase() + name.substring(1);
            OreDictionary.registerOre((String)ore, (ItemStack)chest);
            if (!renderMinecarts3D || event.getSide() != Side.CLIENT) continue;
            MinecraftForgeClient.registerItemRenderer((Item)minecart, (IItemRenderer)new ItemMinecartChestRenderer());
        }
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            if (mapping.type == GameRegistry.Type.BLOCK) {
                if (!"ironchestminecarts:minecart_chest_silver".equals(mapping.name)) continue;
                mapping.remap(GameRegistry.findBlock((String)"ironchestminecarts", (String)"minecart_chest_steel"));
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM || !"ironchestminecarts:minecart_chest_silver".equals(mapping.name)) continue;
            mapping.remap(GameRegistry.findItem((String)"ironchestminecarts", (String)"minecart_chest_steel"));
        }
    }

    static {
        carts = new HashMap<IronChestType, Item>();
    }
}

