/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ChatUtils;
import com.example.examplemod.ConfigHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;

public class ChatHandler {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\{player\\}|\\{message\\}|\\{reset\\}|(?i)&[0-9A-FK-OR]");

    @SubscribeEvent
    public void onChat(ServerChatEvent event) {
        event.setCanceled(true);
        String message = event.message;
        EntityPlayerMP player = event.player;
        World world = player.field_70170_p;
        if (message.startsWith(ConfigHandler.globalPrefix)) {
            String globalMsg = message.substring(ConfigHandler.globalPrefix.length()).trim();
            if (!globalMsg.isEmpty()) {
                this.sendFormattedMessage(player, globalMsg, true);
            }
            return;
        }
        this.sendLocalMessage(player, message, world);
    }

    public void sendLocalMessage(EntityPlayerMP sender, String message, World world) {
        if (message.isEmpty()) {
            return;
        }
        IChatComponent component = this.formatMessage(ConfigHandler.localFormat, sender, message);
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (Object obj : players) {
            EntityPlayerMP player = (EntityPlayerMP)obj;
            if (player.field_70170_p != world || !(sender.func_70068_e((Entity)player) <= ConfigHandler.localRadius * ConfigHandler.localRadius)) continue;
            player.func_145747_a(component);
        }
    }

    public void sendFormattedMessage(EntityPlayerMP player, String message, boolean isGlobal) {
        if (message.isEmpty()) {
            return;
        }
        String format = isGlobal ? ConfigHandler.globalFormat : ConfigHandler.localFormat;
        IChatComponent component = this.formatMessage(format, player, message);
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a(component);
    }

    private IChatComponent formatMessage(String format, EntityPlayerMP player, String messageText) {
        String name = player.func_70005_c_();
        String prefix = ChatUtils.getPlayerPrefix(name);
        String suffix = ChatUtils.getPlayerSuffix(name);
        String faction = ChatUtils.getPlayerFaction(name);
        String factionDisplay = faction.isEmpty() ? "" : "[" + faction + "] ";
        String playerText = factionDisplay + prefix + name + suffix;
        ChatComponentText root = new ChatComponentText("");
        ChatStyle currentStyle = new ChatStyle();
        Matcher m = TOKEN_PATTERN.matcher(format);
        int lastEnd = 0;
        while (m.find()) {
            char code;
            EnumChatFormatting fmt;
            String token;
            if (m.start() > lastEnd) {
                this.appendText((IChatComponent)root, format.substring(lastEnd, m.start()), currentStyle);
            }
            if ("{player}".equals(token = m.group())) {
                this.appendText((IChatComponent)root, playerText, currentStyle);
            } else if ("{message}".equals(token)) {
                ChatStyle msgStyle = currentStyle.func_150232_l().func_150238_a(EnumChatFormatting.GRAY);
                this.appendText((IChatComponent)root, messageText, msgStyle);
                currentStyle = msgStyle;
            } else if ("{reset}".equals(token)) {
                currentStyle = new ChatStyle();
            } else if (token.charAt(0) == '&' && (fmt = this.getByCode(code = Character.toLowerCase(token.charAt(1)))) != null) {
                if (fmt == EnumChatFormatting.RESET) {
                    currentStyle = new ChatStyle();
                } else if (fmt.func_96302_c()) {
                    currentStyle.func_150238_a(fmt).func_150227_a(Boolean.valueOf(false)).func_150217_b(Boolean.valueOf(false)).func_150228_d(Boolean.valueOf(false)).func_150225_c(Boolean.valueOf(false)).func_150237_e(Boolean.valueOf(false));
                } else {
                    switch (fmt) {
                        case BOLD: {
                            currentStyle.func_150227_a(Boolean.valueOf(true));
                            break;
                        }
                        case ITALIC: {
                            currentStyle.func_150217_b(Boolean.valueOf(true));
                            break;
                        }
                        case UNDERLINE: {
                            currentStyle.func_150228_d(Boolean.valueOf(true));
                            break;
                        }
                        case STRIKETHROUGH: {
                            currentStyle.func_150225_c(Boolean.valueOf(true));
                            break;
                        }
                        case OBFUSCATED: {
                            currentStyle.func_150237_e(Boolean.valueOf(true));
                            break;
                        }
                    }
                }
            }
            lastEnd = m.end();
        }
        if (lastEnd < format.length()) {
            this.appendText((IChatComponent)root, format.substring(lastEnd), currentStyle);
        }
        return root;
    }

    private void appendText(IChatComponent root, String text, ChatStyle style) {
        if (text.isEmpty()) {
            return;
        }
        ChatComponentText part = new ChatComponentText(text);
        part.func_150255_a(style.func_150232_l());
        root.func_150257_a((IChatComponent)part);
    }

    private EnumChatFormatting getByCode(char code) {
        for (EnumChatFormatting f : EnumChatFormatting.values()) {
            if (f.func_96298_a() != code) continue;
            return f;
        }
        return null;
    }

    private ChatStyle updateChatStyle(ChatStyle style, EnumChatFormatting format) {
        ChatStyle newStyle = style.func_150232_l();
        if (format == EnumChatFormatting.RESET) {
            return new ChatStyle();
        }
        if (format.func_96302_c()) {
            newStyle.func_150238_a(format);
            newStyle.func_150227_a(Boolean.valueOf(false));
            newStyle.func_150217_b(Boolean.valueOf(false));
            newStyle.func_150228_d(Boolean.valueOf(false));
            newStyle.func_150225_c(Boolean.valueOf(false));
            newStyle.func_150237_e(Boolean.valueOf(false));
        } else {
            switch (format) {
                case BOLD: {
                    newStyle.func_150227_a(Boolean.valueOf(true));
                    break;
                }
                case ITALIC: {
                    newStyle.func_150217_b(Boolean.valueOf(true));
                    break;
                }
                case UNDERLINE: {
                    newStyle.func_150228_d(Boolean.valueOf(true));
                    break;
                }
                case STRIKETHROUGH: {
                    newStyle.func_150225_c(Boolean.valueOf(true));
                    break;
                }
                case OBFUSCATED: {
                    newStyle.func_150237_e(Boolean.valueOf(true));
                    break;
                }
            }
        }
        return newStyle;
    }

    private EnumChatFormatting getFormattingByChar(char code) {
        for (EnumChatFormatting formatting : EnumChatFormatting.values()) {
            if (formatting.func_96298_a() != code) continue;
            return formatting;
        }
        return null;
    }
}

