/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    public static double localRadius;
    public static String globalPrefix;
    public static String localFormat;
    public static String globalFormat;
    public static Map<String, String> prefixMap;
    public static Map<String, String> suffixMap;
    public static Map<String, String> factionMap;
    public static File configFile;

    public static void init(FMLPreInitializationEvent event) {
        configFile = event.getSuggestedConfigurationFile();
        ConfigHandler.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfig() {
        Configuration config = new Configuration(configFile);
        try {
            config.load();
            Property radiusProp = config.get("general", "LocalChatRadius", 50.0);
            radiusProp.comment = "\u0420\u0430\u0434\u0438\u0443\u0441 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0447\u0430\u0442\u0430 (\u0431\u043b\u043e\u043a\u0438)";
            localRadius = radiusProp.getDouble();
            Property prefixProp = config.get("general", "GlobalPrefix", "!");
            prefixProp.comment = "\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0447\u0430\u0442\u0430";
            globalPrefix = prefixProp.getString();
            Property localFormatProp = config.get("general", "LocalFormat", "&e[\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439] &7<{player}&7> {message} {reset}");
            localFormat = localFormatProp.getString();
            Property globalFormatProp = config.get("general", "GlobalFormat", "&c[\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439] &6<{player}&6> {message} {reset}");
            globalFormat = globalFormatProp.getString();
            Property prefixesProp = config.get("prefixes", "PlayerPrefixes", new String[0]);
            prefixesProp.comment = "\u041f\u0440\u0435\u0444\u0438\u043a\u0441\u044b \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435: \u0418\u0433\u0440\u043e\u043a=\u041f\u0440\u0435\u0444\u0438\u043a\u0441";
            ConfigHandler.fillMap(prefixesProp, prefixMap);
            Property suffixesProp = config.get("suffixes", "PlayerSuffixes", new String[0]);
            suffixesProp.comment = "\u0421\u0443\u0444\u0444\u0438\u043a\u0441\u044b \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435: \u0418\u0433\u0440\u043e\u043a=\u0421\u0443\u0444\u0444\u0438\u043a\u0441";
            ConfigHandler.fillMap(suffixesProp, suffixMap);
            Property factionsProp = config.get("factions", "PlayerFactions", new String[0]);
            factionsProp.comment = "\u0424\u0440\u0430\u043a\u0446\u0438\u0438 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435: \u0418\u0433\u0440\u043e\u043a=\u0424\u0440\u0430\u043a\u0446\u0438\u044f";
            ConfigHandler.fillMap(factionsProp, factionMap);
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
            e.printStackTrace();
            localRadius = 50.0;
            globalPrefix = "!";
            localFormat = "&e[\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439] &7<{player}&7> {message}{reset}";
            globalFormat = "&c[\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439] &6<{player}&6> {message}{reset}";
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static void fillMap(Property prop, Map<String, String> map) {
        map.clear();
        for (String entry : prop.getStringList()) {
            String[] parts = entry.split("=", 2);
            if (parts.length != 2) continue;
            String playerName = parts[0].trim();
            String value = parts[1].trim();
            if (playerName.isEmpty()) continue;
            map.put(playerName, value);
        }
    }

    static {
        prefixMap = new HashMap<String, String>();
        suffixMap = new HashMap<String, String>();
        factionMap = new HashMap<String, String>();
    }
}

