/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ChatUtils;
import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class TeamHandler {
    public static void addPlayerToFactionTeam(EntityPlayerMP player, String faction) {
        try {
            if (faction == null || faction.isEmpty()) {
                TeamHandler.removePlayerFromCurrentTeam(player);
                return;
            }
            Scoreboard scoreboard = TeamHandler.getScoreboard();
            if (scoreboard == null) {
                System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c scoreboard!");
                return;
            }
            ScorePlayerTeam team = scoreboard.func_96508_e(faction = TeamHandler.normalizeFactionName(faction));
            if (team == null) {
                team = scoreboard.func_96527_f(faction);
                TeamHandler.setTeamPrefix(team, faction, player);
            }
            TeamHandler.removePlayerFromCurrentTeam(player);
            TeamHandler.addPlayerToTeam(scoreboard, player, faction);
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0438\u0433\u0440\u043e\u043a\u0430 \u0432 \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u0444\u0440\u0430\u043a\u0446\u0438\u0438:");
            e.printStackTrace();
        }
    }

    private static String normalizeFactionName(String faction) {
        if (faction.equalsIgnoreCase("\u0441\u0432\u0435\u0442")) {
            return "\u0421\u0432\u0435\u0442";
        }
        if (faction.equalsIgnoreCase("\u0442\u044c\u043c\u0430")) {
            return "\u0422\u044c\u043c\u0430";
        }
        if (faction.equalsIgnoreCase("admin")) {
            return "admin";
        }
        if (faction.equalsIgnoreCase("\u043d\u0430\u0435\u043c\u043d\u0438\u043a")) {
            return "\u041d\u0430\u0451\u043c\u043d\u0438\u043a";
        }
        return faction;
    }

    private static void setTeamPrefix(ScorePlayerTeam team, String faction, EntityPlayerMP player) throws Exception {
        String fullPrefix;
        Method setPrefixMethod = ScorePlayerTeam.class.getDeclaredMethod("func_96666_b", String.class);
        setPrefixMethod.setAccessible(true);
        String username = player.func_70005_c_();
        String prefix = ChatUtils.getPlayerPrefix(username);
        String suffix = ChatUtils.getPlayerSuffix(username);
        switch (faction) {
            case "\u0421\u0432\u0435\u0442": {
                fullPrefix = "\u00a7e[\u0421\u0432\u0435\u0442] " + prefix;
                break;
            }
            case "\u0422\u044c\u043c\u0430": {
                fullPrefix = "\u00a78[\u0422\u044c\u043c\u0430] " + prefix;
                break;
            }
            case "admin": {
                fullPrefix = "\u00a74[Admin] " + prefix;
                break;
            }
            case "\u041d\u0430\u0451\u043c\u043d\u0438\u043a": {
                fullPrefix = "\u00a75[\u041d\u0430\u0451\u043c\u043d\u0438\u043a] " + prefix;
                break;
            }
            default: {
                fullPrefix = "[" + faction + "] " + prefix;
            }
        }
        setPrefixMethod.invoke((Object)team, fullPrefix);
        Method setSuffixMethod = ScorePlayerTeam.class.getDeclaredMethod("func_96662_c", String.class);
        setSuffixMethod.setAccessible(true);
        setSuffixMethod.invoke((Object)team, suffix);
    }

    private static void addPlayerToTeam(Scoreboard scoreboard, EntityPlayerMP player, String faction) throws Exception {
        Method addToTeamMethod = Scoreboard.class.getDeclaredMethod("func_151392_a", String.class, String.class);
        addToTeamMethod.setAccessible(true);
        addToTeamMethod.invoke((Object)scoreboard, player.func_70005_c_(), faction);
    }

    public static void removePlayerFromCurrentTeam(EntityPlayerMP player) {
        try {
            Scoreboard scoreboard = TeamHandler.getScoreboard();
            if (scoreboard == null) {
                return;
            }
            ScorePlayerTeam team = scoreboard.func_96509_i(player.func_70005_c_());
            if (team != null) {
                scoreboard.func_96512_b(player.func_70005_c_(), team);
            }
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0438\u0433\u0440\u043e\u043a\u0430 \u0438\u0437 \u043a\u043e\u043c\u0430\u043d\u0434\u044b:");
            e.printStackTrace();
        }
    }

    private static Scoreboard getScoreboard() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return null;
        }
        WorldServer world = server.func_71218_a(0);
        if (world == null) {
            return null;
        }
        return world.func_96441_U();
    }
}

