/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.exnihilo.handlers;

import exnihilo.registries.CompostRegistry;
import exnihilo.registries.helpers.Color;
import exnihilo.registries.helpers.Compostable;
import exnihilo.utils.ItemInfo;
import java.util.HashMap;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilo.Composting")
public class Compost {
    public static final String name = "ExNihilo Composting";

    @ZenMethod
    public static void addRecipe(IItemStack input, double value, @Optional String hex) {
        if (input == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        hex = hex == null || hex.equals("") ? "35A82A" : hex;
        HashMap<ItemInfo, Compostable> recipes = new HashMap<ItemInfo, Compostable>();
        recipes.put(new ItemInfo(InputHelper.toStack(input)), new Compostable(Math.min(1.0f, (float)value), new Color(hex)));
        MineTweakerAPI.apply((IUndoableAction)new Add(recipes));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        HashMap<ItemInfo, Compostable> recipes = new HashMap<ItemInfo, Compostable>();
        for (Map.Entry recipe : CompostRegistry.entries.entrySet()) {
            if (!StackHelper.matches(input, InputHelper.toIItemStack(((ItemInfo)recipe.getKey()).getStack()))) continue;
            recipes.put((ItemInfo)recipe.getKey(), (Compostable)recipe.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipes found for %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends BaseMapRemoval<ItemInfo, Compostable> {
        public Remove(Map<ItemInfo, Compostable> recipes) {
            super(Compost.name, CompostRegistry.entries, recipes);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, Compostable> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack());
        }
    }

    private static class Add
    extends BaseMapAddition<ItemInfo, Compostable> {
        public Add(Map<ItemInfo, Compostable> recipes) {
            super(Compost.name, CompostRegistry.entries, recipes);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, Compostable> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack());
        }
    }
}

