/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.factorization.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.factorization.FactorizationHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorization.Lacerator")
public class Lacerator {
    public static final String name = "Factorization Lacerator";

    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output, double probability) {
        Object recipe = FactorizationHelper.getLaceratorRecipe(InputHelper.toObject(input), InputHelper.toStack(output), (float)probability);
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<Object> recipes = new LinkedList<Object>();
        for (Object r : FactorizationHelper.lacerator) {
            if (r == null) continue;
            ItemStack out = (ItemStack)ReflectionHelper.getObject(r, "output");
            if (output == null || !StackHelper.matches(output, InputHelper.toIItemStack(out))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<Object> {
        public Remove(List<Object> recipes) {
            super(Lacerator.name, FactorizationHelper.lacerator, recipes);
        }

        @Override
        public String getRecipeInfo(Object recipe) {
            return LogHelper.getStackDescription((ItemStack)ReflectionHelper.getObject(recipe, "output"));
        }
    }

    private static class Add
    extends BaseListAddition<Object> {
        public Add(Object recipe) {
            super(Lacerator.name, FactorizationHelper.lacerator);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(Object recipe) {
            return LogHelper.getStackDescription((ItemStack)ReflectionHelper.getObject(recipe, "output"));
        }
    }
}

