/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryListAddition;
import modtweaker2.mods.forestry.ForestryListRemoval;
import modtweaker2.mods.forestry.recipes.CentrifugeRecipe;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Centrifuge")
public class Centrifuge {
    public static final String name = "Forestry Centrifuge";

    @ZenMethod
    public static void addRecipe(WeightedItemStack[] output, IItemStack ingredient, int timePerItem) {
        HashMap<ItemStack, Float> products = new HashMap<ItemStack, Float>();
        for (WeightedItemStack product : output) {
            products.put(InputHelper.toStack(product.getStack()), Float.valueOf(product.getChance()));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CentrifugeRecipe(timePerItem, InputHelper.toStack(ingredient), products)));
    }

    @ZenMethod
    @Deprecated
    public static void addRecipe(int timePerItem, IItemStack itemInput, IItemStack[] output, int[] chances) {
        HashMap<ItemStack, Float> products = new HashMap<ItemStack, Float>();
        int i = 0;
        for (IItemStack product : output) {
            products.put(InputHelper.toStack(product), Float.valueOf((float)chances[i] / 100.0f));
            ++i;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CentrifugeRecipe(timePerItem, InputHelper.toStack(itemInput), products)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<ICentrifugeRecipe> recipes = new LinkedList<ICentrifugeRecipe>();
        for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
            if (recipe == null || !StackHelper.matches(input, InputHelper.toIItemStack(recipe.getInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends ForestryListRemoval<ICentrifugeRecipe, ICentrifugeManager> {
        public Remove(List<ICentrifugeRecipe> recipes) {
            super(Centrifuge.name, RecipeManagers.centrifugeManager, recipes);
        }

        @Override
        protected String getRecipeInfo(ICentrifugeRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends ForestryListAddition<ICentrifugeRecipe, ICentrifugeManager> {
        public Add(ICentrifugeRecipe recipe) {
            super(Centrifuge.name, RecipeManagers.centrifugeManager);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(ICentrifugeRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

