/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.MekanismHelper;
import modtweaker2.mods.mekanism.gas.IGasStack;
import modtweaker2.mods.mekanism.gas.MCGasStack;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.Reaction")
public class Reaction {
    public static final String name = "Mekanism Reaction";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, ILiquidStack liquidInput, IGasStack gasInput, IItemStack itemOutput, IGasStack gasOutput, double energy, int duration) {
        if (itemInput == null || liquidInput == null || gasInput == null || itemOutput == null || gasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        PressurizedInput input = new PressurizedInput(InputHelper.toStack(itemInput), InputHelper.toFluid(liquidInput), MekanismHelper.toGas(gasInput));
        PressurizedOutput output = new PressurizedOutput(InputHelper.toStack(itemOutput), MekanismHelper.toGas(gasOutput));
        PressurizedRecipe recipe = new PressurizedRecipe(input, output, energy, duration);
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, IIngredient gasOutput, @Optional IIngredient itemInput, @Optional IIngredient liquidInput, @Optional IIngredient gasInput) {
        if (itemOutput == null || gasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        if (liquidInput == null) {
            liquidInput = IngredientAny.INSTANCE;
        }
        if (gasInput == null) {
            gasInput = IngredientAny.INSTANCE;
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get().entrySet()) {
            IItemStack inputItem = InputHelper.toIItemStack(((PressurizedInput)entry.getKey()).getSolid());
            ILiquidStack inputLiquid = InputHelper.toILiquidStack(((PressurizedInput)entry.getKey()).getFluid());
            MCGasStack inputGas = new MCGasStack(((PressurizedInput)entry.getKey()).getGas());
            IItemStack outputItem = InputHelper.toIItemStack(((PressurizedOutput)((PressurizedRecipe)entry.getValue()).recipeOutput).getItemOutput());
            MCGasStack outputGas = new MCGasStack(((PressurizedOutput)((PressurizedRecipe)entry.getValue()).recipeOutput).getGasOutput());
            if (!StackHelper.matches(itemInput, inputItem) || !StackHelper.matches(liquidInput, inputLiquid) || !StackHelper.matches(gasInput, inputGas) || !StackHelper.matches(itemOutput, outputItem) || !StackHelper.matches(gasOutput, outputGas)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s, %s, %s, %s and %s. Command ignored!", name, itemOutput.toString(), gasOutput.toString(), itemInput.toString(), liquidInput.toString(), gasInput.toString()));
        }
    }
}

