/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct.commands;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mantle.utils.ItemMetaWrapper;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StringHelper;
import modtweaker2.mods.tconstruct.TConstructHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.AlloyMix;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.DryingRackRecipes;

public class TConstructLogger
implements ICommandFunction {
    private static final List<String> validArguments = new LinkedList<String>();

    public void execute(String[] arguments, IPlayer player) {
        List<String> args = StringHelper.toLowerCase(Arrays.asList(arguments));
        if (!validArguments.containsAll(args)) {
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("Invalid arguments for command. Valid arguments: " + StringHelper.join(validArguments, ", ")));
            }
        } else {
            if (args.isEmpty() || args.contains("Casting")) {
                for (CastingRecipe castingRecipe : TConstructHelper.basinCasting) {
                    MineTweakerAPI.logCommand((String)String.format("mods.tconstruct.Casting.addBasinRecipe(%s, %s, %s, %s, %d);", LogHelper.getStackDescription(castingRecipe.output), LogHelper.getStackDescription(castingRecipe.castingMetal), LogHelper.getStackDescription(castingRecipe.cast), castingRecipe.consumeCast, castingRecipe.coolTime));
                }
                for (CastingRecipe castingRecipe : TConstructHelper.tableCasting) {
                    MineTweakerAPI.logCommand((String)String.format("mods.tconstruct.Casting.addTableRecipe(%s, %s, %s, %s, %d);", LogHelper.getStackDescription(castingRecipe.output), LogHelper.getStackDescription(castingRecipe.castingMetal), LogHelper.getStackDescription(castingRecipe.cast), castingRecipe.consumeCast, castingRecipe.coolTime));
                }
            }
            if (args.isEmpty() || args.contains("Drying")) {
                for (DryingRackRecipes.DryingRecipe dryingRecipe : DryingRackRecipes.recipes) {
                    MineTweakerAPI.logCommand((String)String.format("mods.tconstruct.Drying.addRecipe(%s, %s, %d);", LogHelper.getStackDescription(dryingRecipe.input), LogHelper.getStackDescription(dryingRecipe.result), dryingRecipe.time));
                }
            }
            if (args.isEmpty() || args.contains("Smeltery")) {
                for (Map.Entry entry : TConstructHelper.smeltingList.entrySet()) {
                    int temperature = TConstructHelper.temperatureList.get(entry.getKey());
                    ItemStack renderItem = TConstructHelper.renderIndex.get(entry.getKey());
                    MineTweakerAPI.logCommand((String)String.format("mods.tconstruct.Smeltery.addMelting(%s, %s, %d, %s);", LogHelper.getStackDescription(new ItemStack(((ItemMetaWrapper)entry.getKey()).item, 1, ((ItemMetaWrapper)entry.getKey()).meta.intValue())), LogHelper.getStackDescription((FluidStack)entry.getValue()), temperature, LogHelper.getStackDescription(renderItem)));
                }
                for (AlloyMix alloyMix : TConstructHelper.alloys) {
                    MineTweakerAPI.logCommand((String)String.format("mods.tconstruct.Smeltery.addAlloy(%s, %s);", LogHelper.getStackDescription(alloyMix.result), LogHelper.getListDescription(alloyMix.mixers)));
                }
                for (Map.Entry entry : TConstructHelper.fuelList.entrySet()) {
                    MineTweakerAPI.logCommand((String)String.format("mods.tconstruct.Smeltery.addFuel(%s, %d, %d);", LogHelper.getStackDescription(new FluidStack((Fluid)entry.getKey(), 1)), ((Integer[])entry.getValue())[0], ((Integer[])entry.getValue())[1]));
                }
            }
            if (player != null) {
                player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
            }
        }
    }

    static {
        validArguments.add("Casting");
        validArguments.add("Drying");
        validArguments.add("Smeltery");
    }
}

