/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.mods.tconstruct.TConstructHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tconstruct.library.crafting.DryingRackRecipes;

@ZenClass(value="mods.tconstruct.Drying")
public class Drying {
    protected static final String name = "TConstruct Drying Rack";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int time) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(TConstructHelper.getDryingRecipe(InputHelper.toStack(input), time, InputHelper.toStack(output))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient ingredient) {
        LinkedList<DryingRackRecipes.DryingRecipe> recipes = new LinkedList<DryingRackRecipes.DryingRecipe>();
        for (DryingRackRecipes.DryingRecipe recipe : DryingRackRecipes.recipes) {
            if (recipe == null || recipe.result == null || !ingredient.matches(InputHelper.toIItemStack(recipe.result))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, ingredient.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<DryingRackRecipes.DryingRecipe> {
        public Remove(List<DryingRackRecipes.DryingRecipe> list) {
            super(Drying.name, DryingRackRecipes.recipes, list);
        }

        @Override
        protected String getRecipeInfo(DryingRackRecipes.DryingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.result);
        }
    }

    private static class Add
    extends BaseListAddition<DryingRackRecipes.DryingRecipe> {
        public Add(DryingRackRecipes.DryingRecipe recipe) {
            super(Drying.name, DryingRackRecipes.recipes);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(DryingRackRecipes.DryingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.result);
        }
    }
}

