/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.research;

import java.lang.reflect.Field;
import minetweaker.IUndoableAction;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;

public class Difficulty
implements IUndoableAction {
    String key;
    String tab;
    int difficulty;
    int oldDif;
    boolean applied = false;
    static final Field complexity;

    public Difficulty(String res, int dif) {
        this.key = res;
        this.tab = ThaumcraftHelper.getResearchTab(this.key);
        this.difficulty = dif;
    }

    public void apply() {
        ResearchItem research = (ResearchItem)((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)this.tab)).research.get(this.key);
        this.oldDif = research.getComplexity();
        try {
            Field complexity = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("complexity");
            complexity.setAccessible(true);
            complexity.set(research, this.difficulty);
            this.applied = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String describe() {
        return "Changing Complexity for " + this.key;
    }

    public boolean canUndo() {
        return this.applied;
    }

    public void undo() {
        try {
            ResearchItem research = ThaumcraftHelper.getResearchSafe(this.tab, this.key);
            if (research == null || complexity == null) {
                return;
            }
            complexity.setAccessible(true);
            complexity.set(research, this.oldDif);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String describeUndo() {
        return "Restoring Complexity for " + this.key;
    }

    public String getOverrideKey() {
        return null;
    }

    static {
        Field complexity1;
        try {
            complexity1 = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("complexity");
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            complexity1 = null;
            e.printStackTrace();
        }
        complexity = complexity1;
    }
}

