/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram;

import codechicken.nei.recipe.HandlerInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.AutoValue_DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.main.config.DiagramGroupVisibility;
import com.google.auto.value.AutoValue;
import java.util.function.Predicate;

@AutoValue
public abstract class DiagramGroupInfo {
    public abstract String groupName();

    public abstract String groupId();

    public abstract ItemComponent icon();

    public abstract int diagramsPerPage();

    public abstract boolean ignoreNbt();

    public abstract Predicate<Diagram> emptyDiagramPredicate();

    public abstract DiagramGroupVisibility defaultVisibility();

    public abstract String description();

    public void buildHandlerInfo(HandlerInfo.Builder builder) {
        builder.setDisplayStack(this.icon().stack()).setHeight(332 / this.diagramsPerPage()).setMaxRecipesPerPage(this.diagramsPerPage());
    }

    public static Builder builder(String groupName, String groupId, ItemComponent icon, int diagramsPerPage) {
        return new AutoValue_DiagramGroupInfo.Builder().setGroupName(groupName).setGroupId(groupId).setIcon(icon).setDiagramsPerPage(diagramsPerPage).setIgnoreNbt(true).setEmptyDiagramPredicate(diagram -> false).setDefaultVisibility(DiagramGroupVisibility.ALWAYS_SHOWN).setDescription("");
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setGroupName(String var1);

        public abstract Builder setGroupId(String var1);

        public abstract Builder setIcon(ItemComponent var1);

        public abstract Builder setDiagramsPerPage(int var1);

        public abstract Builder setIgnoreNbt(boolean var1);

        public abstract Builder setEmptyDiagramPredicate(Predicate<Diagram> var1);

        public abstract Builder setDefaultVisibility(DiagramGroupVisibility var1);

        public abstract Builder setDescription(String var1);

        public abstract DiagramGroupInfo build();
    }
}

