/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.component;

import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.AutoValue_FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ImmutableNbtWrapper;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.google.auto.value.AutoValue;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@AutoValue
public abstract class FluidComponent
implements Component {
    public static final Comparator<FluidComponent> COMPARATOR = Comparator.comparing(c -> c.fluid().getID()).thenComparing(c -> c.nbtWrapper().orElse(null), ImmutableNbtWrapper.COMPARATOR);
    public static final int DEFAULT_STACK_SIZE = 1000;

    public static FluidComponent create(Fluid fluid, Optional<NBTTagCompound> nbt) {
        return new AutoValue_FluidComponent(fluid, nbt.map(ImmutableNbtWrapper::create));
    }

    public static FluidComponent create(Fluid fluid) {
        return FluidComponent.create(fluid, Optional.empty());
    }

    public static FluidComponent create(FluidStack stack) {
        return FluidComponent.create(stack.getFluid());
    }

    public static FluidComponent createWithNbt(FluidStack stack) {
        return FluidComponent.create(stack.getFluid(), Optional.ofNullable(stack.tag));
    }

    public static FluidComponent createWithNbt(FluidStack stack, NBTTagCompound nbt) {
        return FluidComponent.create(stack.getFluid(), Optional.of(nbt));
    }

    public static Optional<FluidComponent> create(Block block) {
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid == null) {
            return Optional.empty();
        }
        return Optional.of(FluidComponent.create(fluid));
    }

    public abstract Fluid fluid();

    @Override
    public abstract Optional<ImmutableNbtWrapper> nbtWrapper();

    public int fluidId() {
        return this.fluid().getID();
    }

    @Override
    public Component.ComponentType type() {
        return Component.ComponentType.FLUID;
    }

    @Override
    public FluidComponent withNbt(NBTTagCompound nbt) {
        return FluidComponent.create(this.fluid(), Optional.of(nbt));
    }

    @Override
    public FluidComponent withoutNbt() {
        return FluidComponent.create(this.fluid(), Optional.empty());
    }

    public FluidStack stack() {
        return this.stack(1000);
    }

    public FluidStack stack(int stackSize) {
        FluidStack fluidStack = new FluidStack(this.fluid(), stackSize);
        this.nbt().ifPresent(n -> {
            fluidStack.tag = n;
        });
        return fluidStack;
    }

    @Override
    public String description() {
        if (ConfigOptions.SHOW_IDS.get().booleanValue()) {
            return String.format("%s (#%d)", this.stack().getLocalizedName(), this.fluidId());
        }
        return this.stack().getLocalizedName();
    }

    @Override
    public void interact(Interactable.RecipeType recipeType) {
        FluidStack fluidStack = this.stack();
        switch (recipeType) {
            case CRAFTING: {
                GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fluidStack});
                break;
            }
            case USAGE: {
                GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fluidStack});
            }
        }
    }

    @Override
    public void draw(Point pos) {
        Draw.drawFluid(this.fluid(), pos);
    }

    public final String toString() {
        return this.description();
    }

    @Override
    public int compareTo(Component other) {
        if (other == null) {
            return 1;
        }
        if (other instanceof FluidComponent) {
            return COMPARATOR.compare(this, (FluidComponent)other);
        }
        return this.type().compareTo(other.type());
    }
}

