/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.component;

import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.AutoValue_ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ImmutableNbtWrapper;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.google.auto.value.AutoValue;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@AutoValue
public abstract class ItemComponent
implements Component {
    public static final Comparator<ItemComponent> COMPARATOR = Comparator.comparing(c -> Item.func_150891_b((Item)c.item())).thenComparing(ItemComponent::damage).thenComparing(c -> c.nbtWrapper().orElse(null), ImmutableNbtWrapper.COMPARATOR);
    public static final int DEFAULT_STACK_SIZE = 1;

    public static int getItemDamage(ItemStack itemStack) {
        return Items.field_151008_G.getDamage(itemStack);
    }

    public static ItemComponent create(Item item, int damage, Optional<NBTTagCompound> nbt) {
        if (item.func_77645_m()) {
            return new AutoValue_ItemComponent(item, 0, nbt.map(ImmutableNbtWrapper::create));
        }
        return new AutoValue_ItemComponent(item, damage, nbt.map(ImmutableNbtWrapper::create));
    }

    public static ItemComponent create(Item item, int damage) {
        return ItemComponent.create(item, damage, Optional.empty());
    }

    public static ItemComponent create(ItemStack itemStack) {
        return ItemComponent.create(itemStack.func_77973_b(), ItemComponent.getItemDamage(itemStack));
    }

    public static ItemComponent createWithNbt(ItemStack itemStack) {
        return ItemComponent.create(itemStack.func_77973_b(), ItemComponent.getItemDamage(itemStack), Optional.ofNullable(itemStack.field_77990_d));
    }

    public static ItemComponent createWithNbt(ItemStack itemStack, NBTTagCompound nbt) {
        return ItemComponent.create(itemStack.func_77973_b(), ItemComponent.getItemDamage(itemStack), Optional.of(nbt));
    }

    public static Optional<ItemComponent> create(Block block, int damage) {
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return Optional.empty();
        }
        return Optional.of(ItemComponent.create(Item.func_150898_a((Block)block), damage));
    }

    public abstract Item item();

    public abstract int damage();

    @Override
    public abstract Optional<ImmutableNbtWrapper> nbtWrapper();

    public int itemId() {
        return Item.func_150891_b((Item)this.item());
    }

    public boolean hasWildcardDamage() {
        return this.damage() == Short.MAX_VALUE;
    }

    @Override
    public Component.ComponentType type() {
        return Component.ComponentType.ITEM;
    }

    @Override
    public ItemComponent withNbt(NBTTagCompound nbt) {
        return ItemComponent.create(this.item(), this.damage(), Optional.of(nbt));
    }

    @Override
    public ItemComponent withoutNbt() {
        return ItemComponent.create(this.item(), this.damage(), Optional.empty());
    }

    public ItemStack stack() {
        return this.stack(1);
    }

    public ItemStack stack(int stackSize) {
        ItemStack itemStack = new ItemStack(this.item(), stackSize, this.damage());
        this.nbt().ifPresent(n -> {
            itemStack.field_77990_d = n;
        });
        return itemStack;
    }

    @Override
    public String description() {
        if (ConfigOptions.SHOW_IDS.get().booleanValue()) {
            return String.format("%s (#%d/%d)", this.stack().func_82833_r(), this.itemId(), this.damage());
        }
        return this.stack().func_82833_r();
    }

    @Override
    public void interact(Interactable.RecipeType recipeType) {
        ItemStack itemStack = this.stack();
        switch (recipeType) {
            case CRAFTING: {
                GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{itemStack});
                break;
            }
            case USAGE: {
                GuiUsageRecipe.openRecipeGui((String)"item", (Object[])new Object[]{itemStack});
            }
        }
    }

    @Override
    public void draw(Point pos) {
        Draw.drawItem(this.stack(), pos);
    }

    public final String toString() {
        return this.description();
    }

    @Override
    public int compareTo(Component other) {
        if (other == null) {
            return 1;
        }
        if (other instanceof ItemComponent) {
            return COMPARATOR.compare(this, (ItemComponent)other);
        }
        return this.type().compareTo(other.type());
    }
}

