/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.layout.$AutoValue_SlotGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

final class AutoValue_SlotGroup
extends $AutoValue_SlotGroup {
    AutoValue_SlotGroup(int width$, int height$, ImmutableList<Slot> slots$) {
        super(width$, height$, slots$);
    }

    @Override
    public final String toPrettyString() {
        return "SlotGroup {\n  width = " + this.width() + ",\n  height = " + this.height() + ",\n  slots = " + AutoValue_SlotGroup.formatCollectionOfSlot(this.slots(), 1) + ",\n}";
    }

    private static String formatSlot(Slot value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        return value.toPrettyString().replace("\n", "\n" + AutoValue_SlotGroup.$indent(indentLevel));
    }

    private static String formatCollectionOfSlot(Collection<Slot> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("[");
        boolean hasElements = false;
        for (Slot element : value) {
            builder.append("\n").append(AutoValue_SlotGroup.$indent(indentLevel + 1)).append(AutoValue_SlotGroup.formatSlot(element, indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_SlotGroup.$indent(indentLevel));
        }
        return builder.append("]").toString();
    }

    private static String $indent(int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

