/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.tooltip;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.AutoValue_Tooltip;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TextFormatting;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipLine;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.minecraft.util.EnumChatFormatting;

@AutoValue
public abstract class Tooltip {
    private static final Splitter SPLITTER = Splitter.on((char)'\n');
    public static final Tooltip EMPTY_TOOLTIP = Tooltip.builder().build();
    public static final TextFormatting DEFAULT_FORMATTING = TextFormatting.create(false, EnumChatFormatting.RESET);
    public static final TextFormatting SLOT_FORMATTING = TextFormatting.create(false, EnumChatFormatting.AQUA);
    public static final TextFormatting INFO_FORMATTING = TextFormatting.create(false, EnumChatFormatting.YELLOW);
    public static final TextFormatting URGENT_FORMATTING = TextFormatting.create(false, EnumChatFormatting.RED);
    public static final TextFormatting TRIVIAL_FORMATTING = TextFormatting.create(false, EnumChatFormatting.GRAY);
    public static final TextFormatting SPECIAL_FORMATTING = TextFormatting.create(false, EnumChatFormatting.LIGHT_PURPLE);
    public static final int LINE_SPACING = 2;
    public static final int ELEMENT_SPACING = 4;

    public abstract ImmutableList<TooltipLine> lines();

    public int width() {
        return this.lines().stream().mapToInt(TooltipLine::width).max().orElse(0);
    }

    public int height() {
        return 2 * (this.lines().size() - 1) + this.lines().stream().mapToInt(TooltipLine::height).sum();
    }

    public void draw(Point mousePos) {
        Draw.drawTooltip(this, mousePos);
    }

    @ToPrettyString
    public abstract String toPrettyString();

    public static Tooltip create(String line) {
        return Tooltip.builder().addTextLine(line).build();
    }

    public static Tooltip create(String line, TextFormatting formatting) {
        return Tooltip.builder().setFormatting(formatting).addTextLine(line).build();
    }

    public static Tooltip concat(Iterable<Tooltip> tooltips) {
        Builder builder = Tooltip.builder();
        boolean first = true;
        for (Tooltip tooltip : tooltips) {
            if (tooltip.lines().isEmpty()) continue;
            if (!first) {
                builder.addSpacing();
            } else {
                first = false;
            }
            builder.addAllLines((Iterable<TooltipLine>)tooltip.lines());
        }
        return builder.build();
    }

    public static Tooltip concat(Tooltip ... tooltips) {
        return Tooltip.concat(Arrays.asList(tooltips));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<TooltipLine> linesBuilder = ImmutableList.builder();
        private TextFormatting currentFormatting = DEFAULT_FORMATTING;

        public Builder addLine(TooltipLine line) {
            this.linesBuilder.add((Object)line);
            return this;
        }

        public Builder addAllLines(Iterable<TooltipLine> lines) {
            this.linesBuilder.addAll(lines);
            return this;
        }

        public Builder addSpacing() {
            return this.addLine(TooltipLine.builder().setAdditionalSpacing(2).build());
        }

        public Builder addSpacing(int spacing) {
            return this.addLine(TooltipLine.builder().setAdditionalSpacing(spacing).build());
        }

        public Builder addTextLine(String textLine) {
            return this.addAllTextLines(SPLITTER.split((CharSequence)textLine));
        }

        public Builder addAllTextLines(Iterable<String> textLines) {
            for (String textLine : textLines) {
                this.addLine(TooltipLine.builder().addFormatting(this.currentFormatting).addText(textLine).build());
            }
            return this;
        }

        public Builder addDisplayComponent(DisplayComponent displayComponent) {
            return this.addLine(TooltipLine.builder().addFormatting(this.currentFormatting).addDisplayComponentIcon(displayComponent).addComponentDescription(displayComponent.component()).build());
        }

        public Builder addComponent(Component component) {
            return this.addLine(TooltipLine.builder().addFormatting(this.currentFormatting).addComponentIcon(component).addComponentDescription(component).build());
        }

        public Builder addComponentDescription(Component component) {
            return this.addLine(TooltipLine.builder().addFormatting(this.currentFormatting).addComponentDescription(component).build());
        }

        public Builder addAllDisplayComponents(Iterable<? extends DisplayComponent> displayComponents) {
            displayComponents.forEach(this::addDisplayComponent);
            return this;
        }

        public Builder addAllComponents(Iterable<? extends Component> components) {
            components.forEach(this::addComponent);
            return this;
        }

        public Builder setFormatting(TextFormatting formatting) {
            this.currentFormatting = formatting;
            return this;
        }

        public Tooltip build() {
            return new AutoValue_Tooltip((ImmutableList<TooltipLine>)this.linesBuilder.build());
        }
    }
}

