/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.tooltip;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.AutoValue_TooltipLine;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TextFormatting;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipElement;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.EnumChatFormatting;

@AutoValue
public abstract class TooltipLine {
    public abstract ImmutableList<TooltipElement> elements();

    public abstract int additionalSpacing();

    public int width() {
        int width = 0;
        TextFormatting currFormatting = Tooltip.DEFAULT_FORMATTING;
        boolean first = true;
        for (TooltipElement element : this.elements()) {
            if (element.type() == TooltipElement.ElementType.FORMATTING) {
                currFormatting = element.formatting();
                continue;
            }
            if (!first) {
                width += 4;
            } else {
                first = false;
            }
            width += element.width(currFormatting);
        }
        return width;
    }

    public int height() {
        int maxHeight = 0;
        TextFormatting currFormatting = Tooltip.DEFAULT_FORMATTING;
        for (TooltipElement element : this.elements()) {
            if (element.type() == TooltipElement.ElementType.FORMATTING) {
                currFormatting = element.formatting();
                continue;
            }
            maxHeight = Math.max(maxHeight, element.height(currFormatting));
        }
        return maxHeight + this.additionalSpacing();
    }

    @ToPrettyString
    public abstract String toPrettyString();

    public void draw(int x, int y) {
        int currX = x;
        TextFormatting currFormatting = Tooltip.DEFAULT_FORMATTING;
        for (TooltipElement element : this.elements()) {
            if (element.type() == TooltipElement.ElementType.FORMATTING) {
                currFormatting = element.formatting();
                continue;
            }
            int offsetY = y + (this.height() - element.height(currFormatting)) / 2;
            element.draw(currX, offsetY, currFormatting);
            currX += 4 + element.width(currFormatting);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<TooltipElement> elementsBuilder = ImmutableList.builder();
        private int additionalSpacing = 0;

        public Builder addElement(TooltipElement element) {
            this.elementsBuilder.add((Object)element);
            return this;
        }

        public Builder addAllElements(Iterable<TooltipElement> elements) {
            this.elementsBuilder.addAll(elements);
            return this;
        }

        public Builder addSpacing(int spacing) {
            return this.addElement(TooltipElement.ofSpacing(spacing));
        }

        public Builder addText(String text) {
            return this.addElement(TooltipElement.ofText(text));
        }

        public Builder addDisplayComponentIcon(DisplayComponent displayComponent) {
            return this.addElement(TooltipElement.ofDisplayComponentIcon(displayComponent));
        }

        public Builder addComponentIcon(Component component) {
            return this.addElement(TooltipElement.ofComponentIcon(component));
        }

        public Builder addComponentDescription(Component component) {
            return this.addElement(TooltipElement.ofComponentDescription(component));
        }

        public Builder addFormatting(TextFormatting formatting) {
            return this.addElement(TooltipElement.ofFormatting(formatting));
        }

        public Builder addFormatting(EnumChatFormatting formatting) {
            return this.addFormatting(TextFormatting.create(formatting));
        }

        public Builder addFormattingSmall(EnumChatFormatting formatting) {
            return this.addFormatting(TextFormatting.create(true, formatting));
        }

        public Builder setAdditionalSpacing(int additionalSpacing) {
            this.additionalSpacing = additionalSpacing;
            return this;
        }

        public TooltipLine build() {
            return new AutoValue_TooltipLine((ImmutableList<TooltipElement>)this.elementsBuilder.build(), this.additionalSpacing);
        }
    }
}

