/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing;

import bartworks.system.material.Werkstoff;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.ComponentDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.DiagramBuilder;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.LabelHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.main.Registry;
import com.github.dcysteine.neicustomdiagram.util.DiagramUtil;
import com.github.dcysteine.neicustomdiagram.util.bartworks.BartWorksOreDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.collect.ImmutableList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.common.blocks.BlockOresAbstract;
import gtPlusPlus.core.block.base.BlockBaseOre;
import gtPlusPlus.core.material.Material;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class GregTechOreProcessing
implements DiagramGenerator {
    public static final ItemComponent ICON = GregTechOreDictUtil.getAllComponents(OrePrefixes.ore, Materials.Aluminium).stream().filter(GregTechOreProcessing::isGregTechOreBlock).findFirst().get();
    private static final ImmutableList<OrePrefixes> OTHER_ORE_PREFIXES = ImmutableList.of((Object)OrePrefixes.oreBlackgranite, (Object)OrePrefixes.oreRedgranite, (Object)OrePrefixes.oreMarble, (Object)OrePrefixes.oreBasalt, (Object)OrePrefixes.oreNetherrack, (Object)OrePrefixes.oreNether, (Object)OrePrefixes.oreDense, (Object)OrePrefixes.oreRich, (Object)OrePrefixes.oreNormal, (Object)OrePrefixes.oreSmall, (Object)OrePrefixes.orePoor, (Object)OrePrefixes.oreEndstone, (Object[])new OrePrefixes[]{OrePrefixes.oreEnd});
    private final DiagramGroupInfo info;
    private final LabelHandler labelHandler;
    private final LayoutHandler layoutHandler;
    private final RecipeHandler recipeHandler;

    public GregTechOreProcessing(String groupId) {
        this.info = DiagramGroupInfo.builder(Lang.GREGTECH_5_ORE_PROCESSING.trans("groupname"), groupId, ICON, 1).setEmptyDiagramPredicate(DiagramUtil.buildEmptyDiagramPredicate(2)).setDescription("This diagram displays GregTech ore processing products.").build();
        this.labelHandler = new LabelHandler();
        this.layoutHandler = new LayoutHandler(this.info, this.labelHandler);
        this.recipeHandler = new RecipeHandler();
    }

    @Override
    public DiagramGroupInfo info() {
        return this.info;
    }

    @Override
    public DiagramGroup generate() {
        Optional<ItemComponent> trueRawOre;
        this.labelHandler.initialize();
        this.layoutHandler.initialize();
        this.recipeHandler.initialize();
        ComponentDiagramMatcher.Builder matcherBuilder = ComponentDiagramMatcher.builder();
        for (Materials material : Materials.getAll()) {
            List<ItemComponent> rawOres;
            if ((material.mTypes & 8) == 0 || (rawOres = GregTechOreDictUtil.getAllComponents(OrePrefixes.ore, material)).isEmpty()) continue;
            OTHER_ORE_PREFIXES.forEach(prefix -> rawOres.addAll(GregTechOreDictUtil.getAllComponents(prefix, material)));
            trueRawOre = GregTechOreDictUtil.getComponent(OrePrefixes.rawOre, material);
            this.buildDiagram(matcherBuilder, rawOres, trueRawOre);
        }
        if (Registry.ModDependency.BARTWORKS.isLoaded()) {
            for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
                Optional<ItemComponent> rawOre = BartWorksOreDictUtil.getComponent(OrePrefixes.ore, werkstoff);
                trueRawOre = BartWorksOreDictUtil.getComponent(OrePrefixes.rawOre, werkstoff);
                if (!rawOre.isPresent()) continue;
                ArrayList<ItemComponent> rawOres = new ArrayList<ItemComponent>();
                rawOres.add(rawOre.get());
                OTHER_ORE_PREFIXES.forEach(prefix -> BartWorksOreDictUtil.getComponent(prefix, werkstoff).ifPresent(rawOres::add));
                this.buildDiagram(matcherBuilder, rawOres, trueRawOre);
            }
        }
        if (Registry.ModDependency.GT_PLUS_PLUS.isLoaded()) {
            for (Materials material : Material.mMaterialMap) {
                ItemStack ore = material.getOre(1);
                if (ore == null || !(Block.func_149634_a((Item)ore.func_77973_b()) instanceof BlockBaseOre)) continue;
                this.buildDiagram(matcherBuilder, (List<ItemComponent>)ImmutableList.of((Object)ItemComponent.create(ore)), Optional.ofNullable(null));
            }
        }
        return new DiagramGroup(this.info, matcherBuilder.build());
    }

    private void buildDiagram(ComponentDiagramMatcher.Builder matcherBuilder, List<ItemComponent> rawOres, Optional<ItemComponent> trueRawOre) {
        DiagramBuilder diagramBuilder = new DiagramBuilder(this.layoutHandler, this.labelHandler, this.recipeHandler, rawOres, trueRawOre);
        diagramBuilder.buildDiagram(matcherBuilder);
        Logger.GREGTECH_5_ORE_PROCESSING.debug("Generated diagram [{}]", new Object[]{rawOres.get(0)});
    }

    static boolean isGregTechOreBlock(ItemComponent itemComponent) {
        Block block = Block.func_149634_a((Item)itemComponent.item());
        return block instanceof BlockOresAbstract;
    }
}

