/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util.enderstorage;

import codechicken.enderstorage.api.EnderStorageManager;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.util.enderstorage.AutoValue_EnderStorageFrequency;
import com.google.auto.value.AutoValue;
import net.minecraft.init.Blocks;

@AutoValue
public abstract class EnderStorageFrequency {
    public static EnderStorageFrequency create(Colour colour1, Colour colour2, Colour colour3) {
        return new AutoValue_EnderStorageFrequency(colour1, colour2, colour3);
    }

    public static EnderStorageFrequency create(int frequency) {
        Colour[] values = Colour.values();
        int[] colours = EnderStorageManager.getColoursFromFreq((int)frequency);
        return EnderStorageFrequency.create(values[colours[0]], values[colours[1]], values[colours[2]]);
    }

    public static EnderStorageFrequency createReverse(int frequency) {
        Colour[] values = Colour.values();
        int[] colours = EnderStorageManager.getColoursFromFreq((int)frequency);
        return EnderStorageFrequency.create(values[colours[2]], values[colours[1]], values[colours[0]]);
    }

    public abstract Colour colour1();

    public abstract Colour colour2();

    public abstract Colour colour3();

    public int frequency() {
        return EnderStorageManager.getFreqFromColours((int)this.colour1().ordinal(), (int)this.colour2().ordinal(), (int)this.colour3().ordinal());
    }

    public static enum Colour {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        LIGHT_GRAY,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK;


        public DisplayComponent icon() {
            return DisplayComponent.builder(ItemComponent.create(Blocks.field_150325_L, this.ordinal()).get()).build();
        }
    }
}

