/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util.gregtech5;

import com.github.dcysteine.neicustomdiagram.api.Formatter;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFluidDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class GregTechRecipeUtil {
    private static final Joiner STRING_JOINER = Joiner.on((char)' ');

    private GregTechRecipeUtil() {
    }

    public static List<GTRecipe> findRecipeByInput(RecipeMap<?> recipes, Component ... inputs) {
        return GregTechRecipeUtil.findRecipe(recipes, Arrays.asList(inputs), (Collection<? extends Component>)ImmutableList.of());
    }

    public static List<GTRecipe> findRecipeByOutput(RecipeMap<?> recipes, Component ... outputs) {
        return GregTechRecipeUtil.findRecipe(recipes, (Collection<? extends Component>)ImmutableList.of(), Arrays.asList(outputs));
    }

    public static List<GTRecipe> findRecipe(RecipeMap<?> recipes, Component input, Component output) {
        return GregTechRecipeUtil.findRecipe(recipes, (Collection<? extends Component>)ImmutableList.of((Object)input), (Collection<? extends Component>)ImmutableList.of((Object)output));
    }

    public static List<GTRecipe> findRecipe(RecipeMap<?> recipes, Collection<? extends Component> inputs, Collection<? extends Component> outputs) {
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        for (Component component : inputs) {
            switch (component.type()) {
                case ITEM: {
                    inputItems.add(GTOreDictUnificator.get_nocopy((ItemStack)((ItemStack)component.stack())));
                    break;
                }
                case FLUID: {
                    inputFluids.add((FluidStack)component.stack());
                }
            }
        }
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (Component component : outputs) {
            switch (component.type()) {
                case ITEM: {
                    arrayList.add(GTOreDictUnificator.get_nocopy((ItemStack)((ItemStack)component.stack())));
                    break;
                }
                case FLUID: {
                    outputFluids.add((FluidStack)component.stack());
                }
            }
        }
        ArrayList<GTRecipe> foundRecipes = new ArrayList<GTRecipe>();
        for (GTRecipe recipe : recipes.getAllRecipes()) {
            if (!GregTechRecipeUtil.recipeContainsItems(recipe.mInputs, inputItems) || !GregTechRecipeUtil.recipeContainsFluids(recipe.mFluidInputs, inputFluids) || !GregTechRecipeUtil.recipeContainsItems(recipe.mOutputs, arrayList) || !GregTechRecipeUtil.recipeContainsFluids(recipe.mFluidOutputs, outputFluids)) continue;
            foundRecipes.add(recipe);
        }
        return foundRecipes;
    }

    private static boolean recipeContainsFluids(FluidStack[] recipeFluidStacks, Collection<FluidStack> fluidStacks) {
        for (FluidStack fluidStack : fluidStacks) {
            if (!Arrays.stream(recipeFluidStacks).noneMatch(arg_0 -> ((FluidStack)fluidStack).isFluidEqual(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean recipeContainsItems(ItemStack[] recipeItemStacks, Collection<ItemStack> itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            if (!Arrays.stream(recipeItemStacks).noneMatch(s -> GTOreDictUnificator.isInputStackEqual((ItemStack)s, (ItemStack)itemStack))) continue;
            return false;
        }
        return true;
    }

    public static List<DisplayComponent> buildComponentsFromInputs(GTRecipe recipe) {
        ArrayList<DisplayComponent> components = new ArrayList<DisplayComponent>();
        components.addAll(GregTechRecipeUtil.buildComponentsFromItemInputs(recipe));
        components.addAll(GregTechRecipeUtil.buildComponentsFromFluidInputs(recipe));
        return components;
    }

    public static List<DisplayComponent> buildComponentsFromItemInputs(GTRecipe recipe) {
        return GregTechRecipeUtil.buildComponents(recipe.mInputs);
    }

    public static List<DisplayComponent> buildComponentsFromFluidInputs(GTRecipe recipe) {
        return GregTechRecipeUtil.buildComponents(recipe.mFluidInputs);
    }

    public static List<DisplayComponent> buildComponents(ItemStack[] itemStacks) {
        ArrayList<DisplayComponent> displayComponents = new ArrayList<DisplayComponent>();
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == null) continue;
            ItemComponent itemComponent = ItemComponent.createWithNbt(itemStack);
            DisplayComponent.Builder builder = DisplayComponent.builder(itemComponent).setStackSize(itemStack.field_77994_a);
            List<Component> reverseUnifiedItems = GregTechOreDictUtil.reverseUnify(itemComponent);
            if (reverseUnifiedItems.size() > 1) {
                builder.setAdditionalInfo("*").setAdditionalTooltip(Tooltip.builder().setFormatting(Tooltip.INFO_FORMATTING).addTextLine(Lang.GREGTECH_5_UTIL.trans("reverseunifieditems")).setFormatting(Tooltip.DEFAULT_FORMATTING).addAllComponents(reverseUnifiedItems).build());
            }
            displayComponents.add(builder.build());
        }
        return displayComponents;
    }

    public static List<DisplayComponent> buildComponents(FluidStack[] fluidStacks) {
        ArrayList<DisplayComponent> list = new ArrayList<DisplayComponent>();
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack == null) continue;
            FluidComponent fluidComponent = FluidComponent.createWithNbt(fluidStack);
            Component component = GregTechFluidDictUtil.fluidToDisplayItem(fluidComponent).map(Component.class::cast).orElse(fluidComponent);
            list.add(DisplayComponent.builder(component).setStackSize(fluidStack.amount).build());
        }
        return list;
    }

    public static List<DisplayComponent> buildComponentsFromOutputs(GTRecipe recipe) {
        ArrayList<DisplayComponent> components = new ArrayList<DisplayComponent>();
        components.addAll(GregTechRecipeUtil.buildComponentsFromItemOutputs(recipe));
        components.addAll(GregTechRecipeUtil.buildComponentsFromFluidOutputs(recipe));
        return components;
    }

    public static List<DisplayComponent> buildComponentsFromItemOutputs(GTRecipe recipe) {
        ArrayList<DisplayComponent> results = new ArrayList<DisplayComponent>();
        for (int i = 0; i < recipe.mOutputs.length; ++i) {
            Optional<Tooltip> specialConditionsTooltipOptional;
            ItemStack itemStack = recipe.mOutputs[i];
            if (itemStack == null) continue;
            DisplayComponent.Builder builder = DisplayComponent.builderWithNbt(itemStack);
            ArrayList<String> additionalInfoStrings = new ArrayList<String>();
            ArrayList<Tooltip> tooltips = new ArrayList<Tooltip>();
            int chance = recipe.getOutputChance(i);
            if (chance < 10000) {
                double normalizedChance = (double)chance / 100.0;
                String formattedChance = chance % 100 == 0 ? Integer.toString(chance / 100) : Formatter.formatFloat(normalizedChance);
                tooltips.add(Tooltip.create(Lang.GREGTECH_5_UTIL.transf("outputchance", normalizedChance), Tooltip.INFO_FORMATTING));
                additionalInfoStrings.add(formattedChance + "%");
            }
            if ((specialConditionsTooltipOptional = GregTechRecipeUtil.buildSpecialConditionsTooltip(recipe)).isPresent()) {
                additionalInfoStrings.add("*");
                tooltips.add(specialConditionsTooltipOptional.get());
            }
            if (!additionalInfoStrings.isEmpty()) {
                builder.setAdditionalInfo(STRING_JOINER.join(additionalInfoStrings));
            }
            if (!tooltips.isEmpty()) {
                builder.setAdditionalTooltip(Tooltip.concat(tooltips));
            }
            results.add(builder.build());
        }
        return results;
    }

    public static List<DisplayComponent> buildComponentsFromFluidOutputs(GTRecipe recipe) {
        ArrayList<DisplayComponent> results = new ArrayList<DisplayComponent>();
        for (int i = 0; i < recipe.mFluidOutputs.length; ++i) {
            FluidStack fluidStack = recipe.mFluidOutputs[i];
            if (fluidStack == null) continue;
            FluidComponent fluidComponent = FluidComponent.createWithNbt(fluidStack);
            Component component = GregTechFluidDictUtil.fluidToDisplayItem(fluidComponent).map(Component.class::cast).orElse(fluidComponent);
            DisplayComponent.Builder builder = DisplayComponent.builder(component).setStackSize(fluidStack.amount);
            Optional<Tooltip> specialConditionsTooltipOptional = GregTechRecipeUtil.buildSpecialConditionsTooltip(recipe);
            if (specialConditionsTooltipOptional.isPresent()) {
                builder.setAdditionalInfo("*");
                builder.setAdditionalTooltip(specialConditionsTooltipOptional.get());
            }
            results.add(builder.build());
        }
        return results;
    }

    public static boolean requiresCleanroom(GTRecipe recipe) {
        return recipe.mSpecialValue == -200 || recipe.mSpecialValue == -300;
    }

    public static boolean requiresLowGravity(GTRecipe recipe) {
        return recipe.mSpecialValue == -100 || recipe.mSpecialValue == -300;
    }

    private static Optional<Tooltip> buildSpecialConditionsTooltip(GTRecipe recipe) {
        boolean requiresCleanroom = GregTechRecipeUtil.requiresCleanroom(recipe);
        boolean requiresLowGravity = GregTechRecipeUtil.requiresLowGravity(recipe);
        if (requiresCleanroom || requiresLowGravity) {
            Tooltip.Builder tooltipBuilder = Tooltip.builder().setFormatting(Tooltip.INFO_FORMATTING);
            if (requiresCleanroom) {
                tooltipBuilder.addTextLine(Lang.GREGTECH_5_UTIL.trans("recipecleanroom"));
            }
            if (requiresLowGravity) {
                tooltipBuilder.addTextLine(Lang.GREGTECH_5_UTIL.trans("recipelowgravity"));
            }
            return Optional.of(tooltipBuilder.build());
        }
        return Optional.empty();
    }
}

