/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import mods.natura.worldgen.BloodTreeLargeGen;
import mods.natura.worldgen.BushTreeGen;
import mods.natura.worldgen.DarkwoodGen;
import mods.natura.worldgen.EucalyptusTreeGenShort;
import mods.natura.worldgen.FusewoodGen;
import mods.natura.worldgen.RedwoodTreeGen;
import mods.natura.worldgen.SakuraTreeGen;
import mods.natura.worldgen.WhiteTreeGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.TerrainGen;

public class NSaplingBlock
extends BlockSapling {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"redwood", "eucalyptus", "hopseed", "sakura", "ghostwood", "bloodwood", "darkwood", "fusewood"};

    public NSaplingBlock() {
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i] + "_sapling");
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null || block.isReplaceable((IBlockAccess)world, x, y, z)) {
            Block lowerID = world.func_147439_a(x, y - 1, z);
            if (!this.canThisPlantGrowOnThisBlock(lowerID)) {
                Block upperID = world.func_147439_a(x, y + 1, z);
                return this.canThisPlantGrowOnThisBlock(upperID);
            }
            return true;
        }
        return false;
    }

    public boolean canThisPlantGrowOnThisBlock(Block id) {
        return id == Blocks.field_150349_c || id == Blocks.field_150346_d || id == Blocks.field_150425_aM || id == Blocks.field_150424_aL || id == NContent.taintedSoil;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) % 8;
        switch (meta) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Block soil = world.func_147439_a(x, y - 1, z);
                return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && soil != null && soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
            case 4: 
            case 6: 
            case 7: {
                Block netherSoil = world.func_147439_a(x, y - 1, z);
                return netherSoil != null && (netherSoil == Blocks.field_150424_aL || netherSoil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this));
            }
            case 5: {
                Block nSoil = world.func_147439_a(x, y + 1, z);
                return nSoil != null && (nSoil == Blocks.field_150424_aL || nSoil == Blocks.field_150425_aM || nSoil == NContent.taintedSoil);
            }
        }
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) % 8;
        if (meta <= 3) {
            return EnumPlantType.Plains;
        }
        return EnumPlantType.Nether;
    }

    private boolean canGrowRedwood(World world, int x, int y, int z) {
        int numSaplings = 0;
        for (int xPos = -3; xPos <= 3; ++xPos) {
            for (int zPos = -3; zPos <= 3; ++zPos) {
                int ecks = x + xPos;
                int zee = z + zPos;
                if (world.func_147439_a(x + xPos, y, z + zPos) != this || world.func_72805_g(x + xPos, y, z + zPos) % 8 != 0) continue;
                ++numSaplings;
            }
        }
        return numSaplings >= 40;
    }

    private void clearRedwoodGrowthArea(World world, int x, int y, int z) {
        for (int xPos = -4; xPos <= 4; ++xPos) {
            for (int zPos = -4; zPos <= 4; ++zPos) {
                int ecks = x + xPos;
                int zee = z + zPos;
                if (world.func_147439_a(ecks, y, zee) != this || world.func_72805_g(ecks, y, zee) % 8 != 0) continue;
                world.func_147465_d(ecks, y, zee, Blocks.field_150350_a, 0, 4);
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        int md = world.func_72805_g(x, y, z);
        if (md % 8 == 0) {
            if (world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(120) == 0) {
                if ((md & 8) == 0) {
                    world.func_72921_c(x, y, z, md | 8, 4);
                } else {
                    this.func_149879_c(world, x, y, z, random);
                }
            }
        } else if (md % 8 <= 3) {
            if (random.nextInt(10) == 0 && world.func_72957_l(x, y + 1, z) >= 9) {
                if ((md & 8) == 0) {
                    world.func_72921_c(x, y, z, md | 8, 4);
                } else {
                    this.func_149879_c(world, x, y, z, random);
                }
            }
        } else if (random.nextInt(10) == 0) {
            if ((md & 8) == 0) {
                world.func_72921_c(x, y, z, md | 8, 4);
            } else {
                this.func_149879_c(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % 8];
    }

    public void func_149879_c(World p_149879_1_, int p_149879_2_, int p_149879_3_, int p_149879_4_, Random p_149879_5_) {
        int l = p_149879_1_.func_72805_g(p_149879_2_, p_149879_3_, p_149879_4_);
        if ((l & 8) == 0) {
            p_149879_1_.func_72921_c(p_149879_2_, p_149879_3_, p_149879_4_, l | 8, 4);
        } else {
            this.func_149878_d(p_149879_1_, p_149879_2_, p_149879_3_, p_149879_4_, p_149879_5_);
        }
    }

    public void func_149878_d(World world, int x, int y, int z, Random random) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)random, (int)x, (int)y, (int)z)) {
            return;
        }
        int md = world.func_72805_g(x, y, z) % 8;
        Object obj = null;
        if (md == 1) {
            obj = new EucalyptusTreeGenShort(0, 1);
        } else if (md == 2) {
            obj = new BushTreeGen(true, 2, 3, 2);
        } else if (md == 3) {
            obj = new SakuraTreeGen(true, 1, 0);
        } else if (md == 4) {
            obj = new WhiteTreeGen(true, 2, 1);
        } else if (md == 5) {
            obj = new BloodTreeLargeGen(3, 2);
        } else if (md == 6) {
            obj = new DarkwoodGen(true, 3, 0);
        } else if (md == 7) {
            obj = new FusewoodGen(true, 3, 1);
        } else if (this.canGrowRedwood(world, x, y, z)) {
            this.clearRedwoodGrowthArea(world, x, y, z);
            obj = new RedwoodTreeGen(true, NContent.redwood);
        } else {
            return;
        }
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
        if (!obj.func_76484_a(world, random, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, md + 8, 3);
        }
    }

    public int func_149692_a(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 8; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return true;
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return (double)p_149852_1_.field_73012_v.nextFloat() < 0.45;
    }

    public void func_149853_b(World p_149853_1_, Random p_149853_2_, int p_149853_3_, int p_149853_4_, int p_149853_5_) {
        this.func_149879_c(p_149853_1_, p_149853_3_, p_149853_4_, p_149853_5_, p_149853_2_);
    }
}

