/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class DarkwoodGen
extends WorldGenerator {
    private final int minTreeHeight;
    private final int metaWood;
    private final boolean seekGround;

    public DarkwoodGen(boolean notify) {
        this(notify, 4, 0);
    }

    public DarkwoodGen(boolean notify, int minTreeHeight, int logMetadata) {
        super(notify);
        this.minTreeHeight = minTreeHeight;
        this.metaWood = logMetadata;
        this.seekGround = !notify;
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = y;
        do {
            Block blockBelow;
            if ((blockBelow = world.func_147439_a(x, --height, z)) != Blocks.field_150424_aL && blockBelow != Blocks.field_150425_aM && blockBelow != NContent.taintedSoil && height >= 0) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }

    public boolean func_76484_a(World world, Random random, int xPos, int yPos, int zPos) {
        int treeHeight = random.nextInt(3) + this.minTreeHeight;
        if (treeHeight < 4) {
            treeHeight = 4;
        }
        boolean flag = true;
        if (this.seekGround) {
            yPos = this.findGround(world, xPos, yPos, zPos);
        }
        if (yPos >= 1 && yPos + treeHeight + 1 <= 256) {
            boolean isSoil;
            int j1;
            int b0;
            for (int i1 = yPos; i1 <= yPos + 1 + treeHeight; ++i1) {
                b0 = 1;
                if (i1 == yPos) {
                    b0 = 0;
                }
                if (i1 >= yPos + 1 + treeHeight - 2) {
                    b0 = 2;
                }
                for (int l1 = xPos - b0; l1 <= xPos + b0 && flag; ++l1) {
                    for (j1 = zPos - b0; j1 <= zPos + b0 && flag; ++j1) {
                        if (i1 >= 0 && i1 < 256) {
                            Block block = world.func_147439_a(l1, i1, j1);
                            if (block == Blocks.field_150350_a || block.isLeaves((IBlockAccess)world, l1, i1, j1) || block == Blocks.field_150424_aL || block == Blocks.field_150425_aM || block == NContent.taintedSoil || block.isWood((IBlockAccess)world, l1, i1, j1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block soil = world.func_147439_a(xPos, yPos - 1, zPos);
            boolean bl = isSoil = soil.canSustainPlant((IBlockAccess)world, xPos, yPos - 1, zPos, ForgeDirection.UP, (IPlantable)NContent.floraSapling) || soil == Blocks.field_150424_aL;
            if (isSoil && yPos < 256 - treeHeight - 1) {
                soil.onPlantGrow(world, xPos, yPos - 1, zPos, xPos, yPos, zPos);
                b0 = 3;
                int b1 = 0;
                for (j1 = yPos - b0 + treeHeight; j1 <= yPos + treeHeight; ++j1) {
                    int k1 = j1 - (yPos + treeHeight);
                    int i2 = b1 + 1 - k1 / 2;
                    for (int j2 = xPos - i2; j2 <= xPos + i2; ++j2) {
                        int k2 = j2 - xPos;
                        for (int l2 = zPos - i2; l2 <= zPos + i2; ++l2) {
                            Block block;
                            int i3 = l2 - zPos;
                            if (Math.abs(k2) == i2 && Math.abs(i3) == i2 && (random.nextInt(2) == 0 || k1 == 0) || !(block = world.func_147439_a(j2, j1, l2)).canBeReplacedByLeaves((IBlockAccess)world, j2, j1, l2)) continue;
                            this.func_150516_a(world, j2, j1, l2, (Block)NContent.darkLeaves, random.nextInt(25) == 0 ? 2 : (random.nextInt(15) == 0 ? 1 : 0));
                        }
                    }
                }
                for (j1 = 0; j1 < treeHeight; ++j1) {
                    Block block = world.func_147439_a(xPos, yPos + j1, zPos);
                    if (block != Blocks.field_150350_a && !block.isLeaves((IBlockAccess)world, xPos, yPos + j1, zPos) && !block.canBeReplacedByLeaves((IBlockAccess)world, xPos, yPos + j1, zPos)) continue;
                    this.func_150516_a(world, xPos, yPos + j1, zPos, NContent.darkTree, this.metaWood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

