/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class RedwoodTreeGen
extends WorldGenerator {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    Random rand;
    World worldObj;
    int[] fakeOakBasePos = new int[]{0, 0, 0};
    int fakeOakHeightLimit;
    int fakeOakHeight;
    double fakeOakHeightAttenuation = 0.618;
    double fakeOakBranchSlope = 0.381;
    double fakeOakScaleWidth = 1.0;
    double fakeOakLeafDensity = 1.0;
    int fakeOakHeightLimitLimit = 12;
    int fakeOakLeafDistanceLimit = 4;
    int[][] fakeOakLeafNodes;
    double innerBranchSlope = 0.18;
    Block genWoodID;
    int genWoodMetadata = 0;
    boolean useHeight;

    public RedwoodTreeGen(boolean notify, Block woodBlock) {
        super(notify);
        this.useHeight = notify;
        this.rand = new Random();
        this.genWoodID = woodBlock;
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = PHNatura.seaLevel + 64;
        do {
            Block underID;
            if ((underID = world.func_147439_a(x, --height, z)) != Blocks.field_150346_d && underID != Blocks.field_150349_c && height >= PHNatura.seaLevel) continue;
            foundGround = true;
        } while (!foundGround);
        return height;
    }

    public boolean isValidSpawn(World world, int x, int y, int z) {
        Block bID = world.func_147439_a(x, y, z);
        boolean ground = bID == Blocks.field_150346_d || bID == Blocks.field_150349_c;
        boolean transparent = !world.func_147439_a(x, y + 1, z).func_149730_j();
        boolean valid = ground && transparent;
        return ground && transparent;
    }

    public boolean func_76484_a(World world, Random random, int x, int yPos, int z) {
        int groundPoint = yPos;
        if (!this.useHeight && !this.isValidSpawn(world, x, groundPoint = this.findGround(world, x, yPos, z), z)) {
            return false;
        }
        int treeHeight = random.nextInt(60) + 80;
        this.worldObj = world;
        long ran = random.nextLong();
        this.rand.setSeed(ran);
        this.fakeOakBasePos[0] = x;
        this.fakeOakBasePos[1] = groundPoint;
        this.fakeOakBasePos[2] = z;
        this.fakeOakHeightLimit = 10;
        if (treeHeight > 120) {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight / 10) {
                    this.genRing13(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 10) {
                    this.genRing12(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 10) {
                    this.genRing11(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 10) {
                    this.genRing10(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 10) {
                    this.genRing9(world, random, x, currentHeight + groundPoint, z);
                    this.growLowBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 6 / 10) {
                    this.genRing8(world, random, x, currentHeight + groundPoint, z);
                    this.growLowBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 7 / 10) {
                    this.genRing7(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 8 / 10) {
                    this.genRing6(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 9 / 10) {
                    this.genRing5(world, random, x, currentHeight + groundPoint, z);
                    this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                this.genRing3(world, random, x, currentHeight + groundPoint, z);
                this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
            }
            this.growBigRoots(world, random, x, groundPoint - 1, z);
            this.growTop(world, random, x, treeHeight + groundPoint, z);
        } else if (treeHeight > 100) {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight / 8) {
                    this.genRing11(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 8) {
                    this.genRing10(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 8) {
                    this.genRing9(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 8) {
                    this.genRing8(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 8) {
                    this.genRing7(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 6 / 8) {
                    this.genRing6(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 7 / 8) {
                    this.genRing5(world, random, x, currentHeight + groundPoint, z);
                    this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                this.genRing3(world, random, x, currentHeight + groundPoint, z);
                this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
            }
            this.growMediumRoots(world, random, x, groundPoint - 1, z);
            this.growTop(world, random, x, treeHeight + groundPoint, z);
        } else {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight / 6) {
                    this.genRing9(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 6) {
                    this.genRing8(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 6) {
                    this.genRing7(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 6) {
                    this.genRing6(world, random, x, currentHeight + groundPoint, z);
                    this.growMiddleBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 6) {
                    this.genRing5(world, random, x, currentHeight + groundPoint, z);
                    this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
                    continue;
                }
                this.genRing3(world, random, x, currentHeight + groundPoint, z);
                this.growHighBranch(world, random, x, currentHeight + groundPoint, z);
            }
            this.growSmallRoots(world, random, x, groundPoint - 1, z);
            this.growTop(world, random, x, treeHeight + groundPoint, z);
        }
        return true;
    }

    public boolean growTop(World world, Random random, int x, int y, int z) {
        this.fakeOakBasePos[0] = x;
        this.fakeOakBasePos[1] = y + 4;
        this.fakeOakBasePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.fakeOakBasePos[0] = x;
        this.fakeOakBasePos[1] = y + 4;
        this.fakeOakBasePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.fakeOakBasePos[0] = x;
        this.fakeOakBasePos[1] = y;
        this.fakeOakBasePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.fakeOakBasePos[0] = x;
        this.fakeOakBasePos[1] = y;
        this.fakeOakBasePos[2] = z;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        int highestLogY = y;
        for (int offset = 0; offset < 15; ++offset) {
            if (this.worldObj.func_147439_a(x, y + offset, z) != this.genWoodID) continue;
            highestLogY = y + offset;
        }
        for (int currY = y; currY < highestLogY; ++currY) {
            this.func_150516_a(world, x, currY, z, this.genWoodID, this.genWoodMetadata);
        }
        return false;
    }

    public boolean growHighBranch(World world, Random random, int x, int y, int z) {
        for (int iter = 0; iter < 3; ++iter) {
            this.fakeOakBasePos[0] = x + random.nextInt(21) - 10;
            this.fakeOakBasePos[1] = y;
            this.fakeOakBasePos[2] = z + random.nextInt(21) - 10;
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
            this.generateInnerBranch(x, z);
        }
        return false;
    }

    public boolean growMiddleBranch(World world, Random random, int x, int y, int z) {
        for (int iter = 0; iter < 6; ++iter) {
            this.fakeOakBasePos[0] = x + random.nextInt(31) - 15;
            this.fakeOakBasePos[1] = y;
            this.fakeOakBasePos[2] = z + random.nextInt(31) - 15;
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
            this.generateInnerBranch(x, z);
        }
        return false;
    }

    public boolean growLowBranch(World world, Random random, int x, int y, int z) {
        this.fakeOakBasePos[0] = x + random.nextInt(17) - 8;
        this.fakeOakBasePos[1] = y;
        this.fakeOakBasePos[2] = z + random.nextInt(17) - 8;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.generateInnerBranch(x, z);
        if (random.nextInt(2) == 0) {
            this.fakeOakBasePos[0] = x + random.nextInt(17) - 8;
            this.fakeOakBasePos[1] = y;
            this.fakeOakBasePos[2] = z + random.nextInt(17) - 8;
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
            this.generateInnerBranch(x, z);
        }
        this.fakeOakBasePos[0] = x + random.nextInt(17) - 8;
        this.fakeOakBasePos[1] = y;
        this.fakeOakBasePos[2] = z + random.nextInt(17) - 8;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.generateInnerBranch(x, z);
        return false;
    }

    public boolean growSmallRoots(World world, Random random, int x, int y, int z) {
        this.genRing9(world, random, x, y, z);
        this.smallRoot1(world, random, x, y - 1, z);
        this.smallRoot1(world, random, x, y - 2, z);
        this.smallRoot1(world, random, x, y - 3, z);
        this.smallRoot2(world, random, x, y - 4, z);
        this.smallRoot2(world, random, x, y - 5, z);
        this.smallRoot3(world, random, x, y - 6, z);
        this.smallRoot3(world, random, x, y - 7, z);
        this.smallRoot3(world, random, x, y - 8, z);
        this.smallRoot3(world, random, x, y - 9, z);
        this.smallRoot4(world, random, x, y - 10, z);
        this.smallRoot4(world, random, x, y - 11, z);
        return true;
    }

    public boolean growMediumRoots(World world, Random random, int x, int y, int z) {
        this.genRing11(world, random, x, y, z);
        this.mediumRoot1(world, random, x, y - 1, z);
        this.mediumRoot1(world, random, x, y - 2, z);
        this.mediumRoot1(world, random, x, y - 3, z);
        this.mediumRoot2(world, random, x, y - 4, z);
        this.mediumRoot2(world, random, x, y - 5, z);
        this.mediumRoot3(world, random, x, y - 6, z);
        this.mediumRoot3(world, random, x, y - 7, z);
        this.mediumRoot3(world, random, x, y - 8, z);
        this.mediumRoot3(world, random, x, y - 9, z);
        this.mediumRoot4(world, random, x, y - 10, z);
        this.mediumRoot4(world, random, x, y - 11, z);
        this.mediumRoot5(world, random, x, y - 12, z);
        this.mediumRoot5(world, random, x, y - 13, z);
        this.mediumRoot5(world, random, x, y - 14, z);
        return true;
    }

    public boolean growBigRoots(World world, Random random, int x, int j, int k) {
        this.genRing13(world, random, x, j, k);
        this.bigRoot1(world, random, x, j - 1, k);
        this.bigRoot1(world, random, x, j - 2, k);
        this.bigRoot1(world, random, x, j - 3, k);
        this.bigRoot2(world, random, x, j - 4, k);
        this.bigRoot2(world, random, x, j - 5, k);
        this.bigRoot3(world, random, x, j - 6, k);
        this.bigRoot3(world, random, x, j - 7, k);
        this.bigRoot3(world, random, x, j - 8, k);
        this.bigRoot3(world, random, x, j - 9, k);
        this.bigRoot4(world, random, x, j - 10, k);
        this.bigRoot4(world, random, x, j - 11, k);
        this.bigRoot5(world, random, x, j - 12, k);
        this.bigRoot5(world, random, x, j - 13, k);
        this.bigRoot5(world, random, x, j - 14, k);
        this.bigRoot6(world, random, x, j - 15, k);
        this.bigRoot6(world, random, x, j - 16, k);
        this.bigRoot6(world, random, x, j - 17, k);
        this.bigRoot6(world, random, x, j - 18, k);
        return true;
    }

    public boolean smallRoot1(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean smallRoot2(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean smallRoot3(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean smallRoot4(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot1(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot2(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot3(World world, Random random, int x, int j, int k) {
        if (world.func_147439_a(x, j, k) != Blocks.field_150357_h && j > 0) {
            this.func_150516_a(world, x - 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, j, k - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, j, k + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, j, k - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, j, k + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, j, k - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, j, k + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot4(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean mediumRoot5(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot1(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 6, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 6, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 6, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 6, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 6, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 6, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 6, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 6, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot2(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 5, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 5, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 6, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 5, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot3(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot4(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot5(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean bigRoot6(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 2);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 2);
        }
        return true;
    }

    public boolean genRing13(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 6, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 6, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 6, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 6, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 6, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 5, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 5, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 5, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 5, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing12(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 6, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 6, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 6, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 5, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 5, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 5, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 6, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 5, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 5, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 5, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 6, y, z + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing11(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 5, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 5, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 5, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 5, y, z + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing10(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 4, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing9(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 4, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 4, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 4, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 4, y, z + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing8(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 3, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing7(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 3, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 3, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 3, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 3, y, z + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing6(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 2, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z + 2, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing5(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x + 1, y, z + 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 2, y, z + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing4(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 2, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 2, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 2, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing3s(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing3(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata + 1);
            this.func_150516_a(world, x, y, z + 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x + 1, y, z + 1, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing2(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x - 1, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x - 1, y, z, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z - 1, this.genWoodID, this.genWoodMetadata);
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    public boolean genRing1(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && y > 0) {
            this.func_150516_a(world, x, y, z, this.genWoodID, this.genWoodMetadata);
        }
        return true;
    }

    void generateLeafNodeList() {
        int i;
        this.fakeOakHeight = (int)((double)this.fakeOakHeightLimit * this.fakeOakHeightAttenuation);
        if (this.fakeOakHeight >= this.fakeOakHeightLimit) {
            this.fakeOakHeight = this.fakeOakHeightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.fakeOakLeafDensity * (double)this.fakeOakHeightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.fakeOakHeightLimit][4];
        int maxTrunkY = this.fakeOakBasePos[1] + this.fakeOakHeightLimit - this.fakeOakLeafDistanceLimit;
        int k = 1;
        int l = this.fakeOakBasePos[1] + this.fakeOakHeight;
        int trunkHeight = maxTrunkY - this.fakeOakBasePos[1];
        ai[0][0] = this.fakeOakBasePos[0];
        ai[0][1] = maxTrunkY--;
        ai[0][2] = this.fakeOakBasePos[2];
        ai[0][3] = l;
        while (trunkHeight >= 0) {
            float radius = this.layerSize(trunkHeight);
            if (radius < 0.0f) {
                --maxTrunkY;
                --trunkHeight;
                continue;
            }
            double d = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] ai2;
                int posZ;
                double direction;
                double distance = this.fakeOakScaleWidth * ((double)radius * ((double)this.rand.nextFloat() + 0.328));
                int posX = MathHelper.func_76128_c((double)(distance * Math.sin(direction = (double)this.rand.nextFloat() * 2.0 * 3.14159) + (double)this.fakeOakBasePos[0] + d));
                int[] ai1 = new int[]{posX, maxTrunkY, posZ = MathHelper.func_76128_c((double)(distance * Math.cos(direction) + (double)this.fakeOakBasePos[2] + d))};
                if (this.checkBlockLine(ai1, ai2 = new int[]{posX, maxTrunkY + this.fakeOakLeafDistanceLimit, posZ}) != -1) continue;
                int[] ai3 = new int[]{this.fakeOakBasePos[0], this.fakeOakBasePos[1], this.fakeOakBasePos[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.fakeOakBasePos[0] - ai1[0]), 2.0) + Math.pow(Math.abs(this.fakeOakBasePos[2] - ai1[2]), 2.0));
                double d4 = d3 * this.fakeOakBranchSlope;
                ai3[1] = (double)ai1[1] - d4 > (double)l ? l : (int)((double)ai1[1] - d4);
                if (this.checkBlockLine(ai3, ai1) != -1) continue;
                ai[k][0] = posX;
                ai[k][1] = maxTrunkY;
                ai[k][2] = posZ;
                ai[k][3] = ai3[1];
                ++k;
            }
            --maxTrunkY;
            --trunkHeight;
        }
        this.fakeOakLeafNodes = new int[k][4];
        System.arraycopy(ai, 0, this.fakeOakLeafNodes, 0, k);
    }

    void generateBlockCircle(int x, int y, int z, float radius, byte axis, Block block) {
        int i1 = (int)((double)radius + 0.618);
        byte byte1 = otherCoordPairs[axis];
        byte byte2 = otherCoordPairs[axis + 3];
        int[] ai = new int[]{x, y, z};
        int[] ai1 = new int[]{0, 0, 0};
        int k1 = -i1;
        ai1[axis] = ai[axis];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            ai1[byte1] = ai[byte1] + j1;
            int l1 = -i1;
            while (l1 <= i1) {
                double d = Math.sqrt(Math.pow((double)Math.abs(j1) + 0.5, 2.0) + Math.pow((double)Math.abs(l1) + 0.5, 2.0));
                if (d > (double)radius) {
                    ++l1;
                    continue;
                }
                ai1[byte2] = ai[byte2] + l1;
                Block i2 = this.worldObj.func_147439_a(ai1[0], ai1[1], ai1[2]);
                if (i2 != Blocks.field_150350_a && i2 != Blocks.field_150362_t) {
                    ++l1;
                    continue;
                }
                this.func_150516_a(this.worldObj, ai1[0], ai1[1], ai1[2], block, 0);
                ++l1;
            }
        }
    }

    float layerSize(int i) {
        if ((double)i < (double)this.fakeOakHeightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.fakeOakHeightLimit / 2.0f;
        float f1 = (float)this.fakeOakHeightLimit / 2.0f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float calculateLeafRadius(int height) {
        if (height < 0 || height >= this.fakeOakLeafDistanceLimit) {
            return -1.0f;
        }
        return height == 0 || height == this.fakeOakLeafDistanceLimit - 1 ? 2.0f : 3.0f;
    }

    void generateLeafNode(int x, int y, int z) {
        int i1 = y + this.fakeOakLeafDistanceLimit;
        for (int l = y; l < i1; ++l) {
            float f = this.calculateLeafRadius(l - y);
            this.generateBlockCircle(x, l, z, f, (byte)1, (Block)NContent.floraLeaves);
        }
    }

    void placeBlockLine(int[] start, int[] end, Block block) {
        int[] delta = new int[]{0, 0, 0};
        int longestAxis = 0;
        for (int axis = 0; axis < 3; axis = (int)((byte)(axis + 1))) {
            delta[axis] = end[axis] - start[axis];
            if (Math.abs(delta[axis]) <= Math.abs(delta[longestAxis])) continue;
            longestAxis = axis;
        }
        if (delta[longestAxis] == 0) {
            return;
        }
        byte axisA = otherCoordPairs[longestAxis];
        byte axisB = otherCoordPairs[longestAxis + 3];
        int longestAxisSign = delta[longestAxis] > 0 ? 1 : -1;
        double d = (double)delta[axisA] / (double)delta[longestAxis];
        double d1 = (double)delta[axisB] / (double)delta[longestAxis];
        int[] currentPos = new int[]{0, 0, 0};
        int l = delta[longestAxis] + longestAxisSign;
        for (int k = 0; k != l; k += longestAxisSign) {
            currentPos[longestAxis] = MathHelper.func_76128_c((double)((double)(start[longestAxis] + k) + 0.5));
            currentPos[axisA] = MathHelper.func_76128_c((double)((double)start[axisA] + (double)k * d + 0.5));
            currentPos[axisB] = MathHelper.func_76128_c((double)((double)start[axisB] + (double)k * d1 + 0.5));
            Block occupiedBy = this.worldObj.func_147439_a(currentPos[0], currentPos[1], currentPos[2]);
            if (occupiedBy != NContent.floraLeaves && occupiedBy != Blocks.field_150350_a) continue;
            this.func_150516_a(this.worldObj, currentPos[0], currentPos[1], currentPos[2], block, 0);
        }
    }

    void generateLeaves() {
        for (int iter = 0; iter < this.fakeOakLeafNodes.length; ++iter) {
            int posX = this.fakeOakLeafNodes[iter][0];
            int posY = this.fakeOakLeafNodes[iter][1];
            int posZ = this.fakeOakLeafNodes[iter][2];
            this.generateLeafNode(posX, posY, posZ);
        }
    }

    boolean leafNodeNeedsBase(int i) {
        return true;
    }

    void generateLeafNodeBases() {
        int j = this.fakeOakLeafNodes.length;
        int[] ai = new int[]{this.fakeOakBasePos[0], this.fakeOakBasePos[1], this.fakeOakBasePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.fakeOakLeafNodes[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.fakeOakBasePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(ai, ai2, NContent.redwood);
        }
    }

    void generateInnerBranch(int trunkX, int trunkZ) {
        int offset = 0;
        while (this.worldObj.func_147439_a(this.fakeOakBasePos[0], this.fakeOakBasePos[1] + offset, this.fakeOakBasePos[2]) != this.genWoodID && ++offset <= 5) {
        }
        int[] start = new int[]{this.fakeOakBasePos[0], this.fakeOakBasePos[1] + offset, this.fakeOakBasePos[2]};
        int[] end = new int[]{trunkX, -1, trunkZ};
        double xzDistance = Math.sqrt(Math.pow(Math.abs(start[0] - end[0]), 2.0) + Math.pow(Math.abs(start[2] - end[2]), 2.0));
        double yDistance = this.innerBranchSlope * xzDistance;
        end[1] = start[1] - (int)yDistance;
        this.placeBlockLine(start, end, NContent.redwood);
    }

    int checkBlockLine(int[] start, int[] end) {
        int i;
        int[] offset = new int[]{0, 0, 0};
        int longestAxisIndex = 0;
        for (int axisIndex = 0; axisIndex < 3; axisIndex = (int)((byte)(axisIndex + 1))) {
            offset[axisIndex] = end[axisIndex] - start[axisIndex];
            if (Math.abs(offset[axisIndex]) <= Math.abs(offset[longestAxisIndex])) continue;
            longestAxisIndex = axisIndex;
        }
        if (offset[longestAxisIndex] == 0) {
            return -1;
        }
        byte otherAxisIndex1 = otherCoordPairs[longestAxisIndex];
        byte otherAxisIndex2 = otherCoordPairs[longestAxisIndex + 3];
        int longestAxisSign = offset[longestAxisIndex] > 0 ? 1 : -1;
        double d = (double)offset[otherAxisIndex1] / (double)offset[longestAxisIndex];
        double d1 = (double)offset[otherAxisIndex2] / (double)offset[longestAxisIndex];
        int[] currentPos = new int[]{0, 0, 0};
        int targetLength = offset[longestAxisIndex] + longestAxisSign;
        for (i = 0; i != targetLength; i += longestAxisSign) {
            currentPos[longestAxisIndex] = start[longestAxisIndex] + i;
            currentPos[otherAxisIndex1] = MathHelper.func_76128_c((double)((double)start[otherAxisIndex1] + (double)i * d));
            currentPos[otherAxisIndex2] = MathHelper.func_76128_c((double)((double)start[otherAxisIndex2] + (double)i * d1));
            Block block = this.worldObj.func_147439_a(currentPos[0], currentPos[1], currentPos[2]);
            if (block != Blocks.field_150350_a && block != NContent.floraLeaves && block != NContent.redwood) break;
        }
        if (i == targetLength) {
            return -1;
        }
        return Math.abs(i);
    }
}

