/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPatternTerm;
import codechicken.nei.recipe.StackInfo;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.glodblock.github.common.item.ItemFluidPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class PacketStackCountChange
implements IMessage {
    private int slotIndex;
    private int changeCount;

    public PacketStackCountChange() {
    }

    public PacketStackCountChange(int slotIndex, int changeCount) {
        this.slotIndex = slotIndex;
        this.changeCount = changeCount;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void fromBytes(ByteBuf buf) {
        this.slotIndex = buf.readInt();
        this.changeCount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slotIndex);
        buf.writeInt(this.changeCount);
    }

    public static final class Handler
    implements IMessageHandler<PacketStackCountChange, IMessage> {
        public IMessage onMessage(PacketStackCountChange message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof AEBaseContainer) {
                this.handleMessage(message, container);
            }
            return null;
        }

        private void handleMessage(PacketStackCountChange message, Container container) {
            if (container instanceof ContainerPatternTerm && ((ContainerPatternTerm)container).isCraftingMode()) {
                return;
            }
            Slot currentSlot = container.func_75139_a(message.getSlotIndex());
            if (currentSlot.func_75216_d()) {
                ItemStack stack = currentSlot.func_75211_c();
                if (GuiUtils.isFluidCraftPatternContainer(container) && StackInfo.itemStackToNBT((ItemStack)stack).func_74764_b("gtFluidName")) {
                    FluidStack fluid = StackInfo.getFluid((ItemStack)stack);
                    fluid.amount = Math.max(1, fluid.amount + message.getChangeCount());
                    currentSlot.func_75215_d(ItemFluidPacket.newStack((FluidStack)fluid));
                } else {
                    stack = stack.func_77946_l();
                    stack.field_77994_a = Math.max(1, stack.field_77994_a + message.getChangeCount());
                    currentSlot.func_75215_d(stack);
                }
            }
        }
    }
}

