/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.TaskProfiler;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.util.AsyncTaskProfiler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class ProfilerRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    private static final AsyncTaskProfiler profiler = new AsyncTaskProfiler();
    private final boolean crafting;

    public static AsyncTaskProfiler getProfiler() {
        return profiler;
    }

    public ProfilerRecipeHandler(boolean crafting) {
        this.crafting = crafting;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.profiler." + (this.crafting ? "crafting" : "usage"), new Object[0]);
    }

    @Override
    public int numRecipes() {
        if (!NEIClientConfig.isProfileRecipeEnabled()) {
            return 0;
        }
        return (int)Math.ceil((double)((this.crafting ? GuiCraftingRecipe.craftinghandlers.size() : GuiUsageRecipe.usagehandlers.size()) - 1) / 6.0);
    }

    @Override
    public void drawBackground(int recipe) {
    }

    @Override
    public void drawForeground(int recipe) {
        List<TaskProfiler.ProfilerResult> results = profiler.getResults();
        results.removeIf(profilerResult -> this.getRecipeName().equals(profilerResult.name));
        results.sort((o1, o2) -> o1.time < o2.time ? 1 : -1);
        for (int i = recipe * 6; i < results.size() && i < (recipe + 1) * 6; ++i) {
            TaskProfiler.ProfilerResult r = results.get(i);
            int y = i % 6 * 20 + 6;
            GuiDraw.drawString((String)r.name, (int)8, (int)y, (int)-8355712, (boolean)false);
            String s = r.time < 1000000L ? r.time / 1000L + "us" : r.time / 1000000L + "ms";
            GuiDraw.drawString((String)s, (int)(156 - GuiDraw.getStringWidth((String)s)), (int)(y + 10), (int)-12566464, (boolean)false);
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public ArrayList<PositionedStack> getOtherStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    @Override
    public PositionedStack getResultStack(int recipe) {
        return null;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    @Override
    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    @Override
    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public boolean keyTyped(GuiRecipe<?> gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    @Override
    public boolean mouseClicked(GuiRecipe<?> gui, int button, int recipe) {
        return false;
    }

    @Override
    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        return this;
    }

    @Override
    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        return this;
    }
}

