/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import openblocks.Config;
import openblocks.api.InventoryEvent;
import openmods.Log;
import openmods.inventory.GenericInventory;
import openmods.utils.ItemUtils;
import openmods.utils.TagUtils;
import org.apache.commons.lang3.StringUtils;

public class PlayerInventoryStore {
    public static final String TAG_PLAYER_UUID = "PlayerUUID";
    public static final String TAG_PLAYER_NAME = "PlayerName";
    private static final String TAG_LOCATION = "Location";
    private static final String TAG_INVENTORY = "Inventory";
    private static final String TAG_SUB_INVENTORIES = "SubInventories";
    private static final String TAG_SLOT = "Slot";
    private final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final Pattern SAFE_CHARS = Pattern.compile("[^A-Za-z0-9_-]");
    private static final String PREFIX = "inventory-";
    public static final PlayerInventoryStore instance = new PlayerInventoryStore();

    private PlayerInventoryStore() {
    }

    private synchronized File getNewDumpFile(Date date, String player, World world, String type) {
        String dateStr = this.formatter.format(date);
        int id = 0;
        while (true) {
            String filename = String.format("inventory-%s-%s-%s-%d", player, dateStr, type, id);
            File file = world.func_72860_G().func_75758_b(filename);
            if (!file.exists()) {
                return file;
            }
            ++id;
        }
    }

    private static String stripFilename(String name) {
        return StringUtils.removeEndIgnoreCase((String)StringUtils.removeStartIgnoreCase((String)name, (String)PREFIX), (String)".dat");
    }

    public File storePlayerInventory(EntityPlayer player, String type) {
        InventoryEvent.Store evt = new InventoryEvent.Store(player);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        GameProfile profile = player.func_146103_bH();
        return this.storeInventory((IInventory)player.field_71071_by, profile.getName(), type, player.field_70170_p, PlayerInventoryStore.createExtrasFiller(profile, player.field_70165_t, player.field_70163_u, player.field_70161_v, evt.getSubInventories()));
    }

    private static ExtrasFiller createExtrasFiller(final GameProfile profile, final double x, final double y, final double z, final Map<String, InventoryEvent.SubInventory> subs) {
        return new ExtrasFiller(){

            @Override
            public void addExtras(NBTTagCompound meta) {
                meta.func_74778_a(PlayerInventoryStore.TAG_PLAYER_NAME, profile.getName());
                meta.func_74778_a(PlayerInventoryStore.TAG_PLAYER_UUID, profile.getId().toString());
                meta.func_74782_a(PlayerInventoryStore.TAG_LOCATION, (NBTBase)TagUtils.store((double)x, (double)y, (double)z));
                NBTTagCompound subInventories = new NBTTagCompound();
                for (Map.Entry e : subs.entrySet()) {
                    NBTTagList subInventory = new NBTTagList();
                    for (Map.Entry<Integer, ItemStack> ie : ((InventoryEvent.SubInventory)e.getValue()).asMap().entrySet()) {
                        ItemStack stack = ie.getValue();
                        if (stack == null) continue;
                        NBTTagCompound stacktag = ItemUtils.writeStack((ItemStack)stack);
                        stacktag.func_74768_a(PlayerInventoryStore.TAG_SLOT, ie.getKey().intValue());
                        subInventory.func_74742_a((NBTBase)stacktag);
                    }
                    subInventories.func_74782_a((String)e.getKey(), (NBTBase)subInventory);
                }
                meta.func_74782_a(PlayerInventoryStore.TAG_SUB_INVENTORIES, (NBTBase)subInventories);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File storeInventory(IInventory inventory, String name, String type, World world, ExtrasFiller filler) {
        GenericInventory copy = new GenericInventory("tmp", false, inventory.func_70302_i_());
        copy.copyFrom(inventory);
        Date now = new Date();
        Matcher matcher = SAFE_CHARS.matcher(name);
        String playerName = matcher.replaceAll("_");
        File dumpFile = this.getNewDumpFile(now, playerName, world, type);
        NBTTagCompound root = new NBTTagCompound();
        NBTTagCompound invData = new NBTTagCompound();
        copy.writeToNBT(invData);
        root.func_74782_a(TAG_INVENTORY, (NBTBase)invData);
        root.func_74772_a("Created", now.getTime());
        root.func_74778_a("Type", type);
        filler.addExtras(root);
        try (FileOutputStream stream = new FileOutputStream(dumpFile);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)root, (OutputStream)stream);
        }
        catch (IOException e) {
            Log.warn((Throwable)e, (String)"Failed to dump data for player %s, file %s", (Object[])new Object[]{name, dumpFile.getAbsoluteFile()});
        }
        return dumpFile;
    }

    private static IInventory loadInventory(NBTTagCompound rootTag) {
        if (!rootTag.func_150297_b(TAG_INVENTORY, 10)) {
            Log.debug((String)"No main inventory found", (Object[])new Object[0]);
            return null;
        }
        NBTTagCompound invTag = rootTag.func_74775_l(TAG_INVENTORY);
        GenericInventory result = new GenericInventory("tmp", false, 0);
        result.readFromNBT(invTag);
        return result;
    }

    private static InventoryEvent.SubInventory loadSubInventory(NBTTagList subTag) {
        InventoryEvent.SubInventory result = new InventoryEvent.SubInventory();
        for (int i = 0; i < subTag.func_74745_c(); ++i) {
            NBTTagCompound itemTag = subTag.func_150305_b(i);
            if (itemTag.func_82582_d()) continue;
            int slot = itemTag.func_74762_e(TAG_SLOT);
            ItemStack stack = ItemUtils.readStack((NBTTagCompound)itemTag);
            if (stack == null) continue;
            result.addItemStack(slot, stack);
        }
        return result;
    }

    private static Map<String, InventoryEvent.SubInventory> loadSubInventories(NBTTagCompound subsTag) {
        HashMap result = Maps.newHashMap();
        Set keys = subsTag.func_150296_c();
        for (String key : keys) {
            NBTTagList subTag = subsTag.func_150295_c(key, 10);
            InventoryEvent.SubInventory sub = PlayerInventoryStore.loadSubInventory(subTag);
            result.put(key, sub);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NBTTagCompound loadInventoryTag(World world, String fileId) {
        NBTTagCompound nBTTagCompound;
        File file = world.func_72860_G().func_75758_b(PREFIX + PlayerInventoryStore.stripFilename(fileId));
        FileInputStream stream = new FileInputStream(file);
        try {
            nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException e) {
                Log.warn((Throwable)e, (String)"Failed to read data from file %s", (Object[])new Object[]{file.getAbsoluteFile()});
                return null;
            }
        }
        ((InputStream)stream).close();
        return nBTTagCompound;
    }

    public List<String> getMatchedDumps(World world, String prefix) {
        File saveFolder = PlayerInventoryStore.getSaveFolder(world);
        final String actualPrefix = StringUtils.startsWithIgnoreCase((CharSequence)prefix, (CharSequence)PREFIX) ? prefix : PREFIX + prefix;
        File[] files = saveFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(actualPrefix);
            }
        });
        ArrayList result = Lists.newArrayList();
        int toCut = PREFIX.length();
        for (File f : files) {
            String name = f.getName();
            result.add(name.substring(toCut, name.length() - 4));
        }
        return result;
    }

    public static File getSaveFolder(World world) {
        File dummy = world.func_72860_G().func_75758_b("dummy");
        return dummy.getParentFile();
    }

    public LoadedInventories loadInventories(World world, String fileId) {
        Map<Object, Object> subInventories;
        NBTTagCompound rootTag = PlayerInventoryStore.loadInventoryTag(world, fileId);
        if (rootTag == null) {
            return null;
        }
        IInventory mainInventory = PlayerInventoryStore.loadInventory(rootTag);
        if (rootTag.func_150297_b(TAG_SUB_INVENTORIES, 10)) {
            NBTTagCompound subsTag = rootTag.func_74775_l(TAG_SUB_INVENTORIES);
            subInventories = PlayerInventoryStore.loadSubInventories(subsTag);
        } else {
            subInventories = Maps.newHashMap();
        }
        return new LoadedInventories(mainInventory, subInventories);
    }

    public boolean restoreInventory(EntityPlayer player, String fileId) {
        Map<String, InventoryEvent.SubInventory> subs;
        LoadedInventories inventories = this.loadInventories(player.field_70170_p, fileId);
        if (inventories == null) {
            return false;
        }
        IInventory main = inventories.mainInventory;
        if (main != null) {
            InventoryPlayer current = player.field_71071_by;
            int targetInventorySize = current.func_70302_i_();
            int sourceInventorySize = main.func_70302_i_();
            for (int i = 0; i < sourceInventorySize; ++i) {
                ItemStack stack = main.func_70301_a(i);
                if (i < targetInventorySize) {
                    current.func_70299_a(i, stack);
                    continue;
                }
                player.func_71019_a(stack, false);
            }
        }
        if ((subs = inventories.subInventories) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new InventoryEvent.Load(player, subs));
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerDeath(LivingDeathEvent event) {
        if (Config.dumpStiffsStuff && event.entity instanceof EntityPlayerMP && !(event.entity instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)event.entity;
            String playerName = player.getDisplayName();
            try {
                File file = this.storePlayerInventory(player, "death");
                Log.info((String)"Storing post-mortem inventory into %s. It can be restored with command '/ob_inventory restore %s %s'", (Object[])new Object[]{file.getAbsolutePath(), playerName, PlayerInventoryStore.stripFilename(file.getName())});
            }
            catch (Exception e) {
                Log.severe((Throwable)e, (String)"Failed to store inventory for player %s", (Object[])new Object[]{playerName});
            }
        }
    }

    public static interface ExtrasFiller {
        public void addExtras(NBTTagCompound var1);
    }

    public static class LoadedInventories {
        public final IInventory mainInventory;
        public Map<String, InventoryEvent.SubInventory> subInventories;

        private LoadedInventories(IInventory mainInventory, Map<String, InventoryEvent.SubInventory> subInventories) {
            this.mainInventory = mainInventory;
            this.subInventories = subInventories;
        }
    }
}

