/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.rpc.IGuideAnimationTrigger;
import openmods.shapes.IShapeable;
import openmods.utils.Coord;
import openmods.utils.render.GeometryUtils;

public class TileEntityBuilderGuide
extends TileEntityGuide
implements IGuideAnimationTrigger {
    private static final Random RANDOM = new Random();
    private int ticks;

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1 && this.shouldRender();
    }

    @Override
    public boolean onItemUse(EntityPlayerMP player, ItemStack heldStack, int side, float hitX, float hitY, float hitZ) {
        Item heldItem;
        if (this.active.get() && (heldItem = heldStack.func_77973_b()) instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)heldItem;
            Block block = itemBlock.field_150939_a;
            int blockMeta = itemBlock.func_77647_b(heldStack.func_77960_j());
            if (player.field_71075_bZ.field_75098_d && this.isInFillMode()) {
                this.creativeReplaceBlocks(block, blockMeta);
                return true;
            }
            return this.survivalPlaceBlocks(itemBlock, player, heldStack, block, blockMeta, side, hitX, hitY, hitZ);
        }
        return super.onItemUse(player, heldStack, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            ++this.ticks;
        }
    }

    private void creativeReplaceBlocks(Block block, int blockMeta) {
        for (Coord coord : this.getShapeSafe().getCoords()) {
            this.field_145850_b.func_147465_d(this.field_145851_c + coord.x, this.field_145848_d + coord.y, this.field_145849_e + coord.z, block, blockMeta, 3);
        }
    }

    @Override
    protected boolean canAddCoord(int x, int y, int z) {
        return Math.abs(x) > 1 || Math.abs(y) > 1 || Math.abs(z) > 1;
    }

    private boolean survivalPlaceBlocks(ItemBlock itemBlock, EntityPlayerMP player, ItemStack heldItem, Block block, int blockMeta, int side, float hitX, float hitY, float hitZ) {
        for (Coord relCoord : this.getShapeSafe().getCoords()) {
            int absX = relCoord.x + this.field_145851_c;
            int absY = relCoord.y + this.field_145848_d;
            int absZ = relCoord.z + this.field_145849_e;
            if (!this.field_145850_b.func_72899_e(absX, absY, absZ) || !this.field_145850_b.func_147437_c(absX, absY, absZ)) continue;
            BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((World)this.field_145850_b, (int)absX, (int)absY, (int)absZ);
            BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(snapshot, this.field_145850_b.func_147439_a(absX, absY, absZ), (EntityPlayer)player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                itemBlock.placeBlockAt(heldItem, (EntityPlayer)player, this.field_145850_b, absX, absY, absZ, side, hitX, hitY, hitZ, blockMeta);
                String particle = "blockdust_" + Block.func_149682_b((Block)block) + "_" + blockMeta;
                ((IGuideAnimationTrigger)this.createServerRpcProxy(IGuideAnimationTrigger.class, new Class[0])).trigger(absX, absY, absZ, particle);
                --heldItem.field_77994_a;
                return true;
            }
            snapshot.restore();
        }
        return false;
    }

    private boolean isInFillMode() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150343_Z;
    }

    public float getTicks() {
        return this.ticks;
    }

    @Override
    public void trigger(int x, int y, int z, final String particle) {
        GeometryUtils.line3D((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)x, (int)y, (int)z, (IShapeable)new IShapeable(){

            public void setBlock(int x, int y, int z) {
                double dx = (double)x + 0.5;
                double dy = (double)y + 0.5;
                double dz = (double)z + 0.5;
                for (int i = 0; i < 5; ++i) {
                    double px = dx + 0.3 * (double)RANDOM.nextFloat();
                    double py = dy + 0.3 * (double)RANDOM.nextFloat();
                    double pz = dz + 0.3 * (double)RANDOM.nextFloat();
                    TileEntityBuilderGuide.this.field_145850_b.func_72869_a("portal", px, py, pz, 0.0, 0.0, 0.0);
                    TileEntityBuilderGuide.this.field_145850_b.func_72869_a(particle, px, py, pz, 0.0, 0.0, 0.0);
                }
            }
        });
    }
}

