/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.client.gui.GuiItemDropper;
import openblocks.common.container.ContainerItemDropper;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.InventoryUtils;

public class TileEntityItemDropper
extends OpenTileEntity
implements INeighbourAwareTile,
IInventoryProvider,
IHasGui {
    static final int BUFFER_SIZE = 9;
    private boolean _redstoneSignal;
    private GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "itemDropper", false, 9));

    public void setRedstoneSignal(boolean redstoneSignal) {
        if (redstoneSignal != this._redstoneSignal) {
            this._redstoneSignal = redstoneSignal;
            if (this._redstoneSignal && !InventoryUtils.inventoryIsEmpty((IInventory)this.inventory)) {
                this.dropItem();
            }
        }
    }

    private void dropItem() {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            final ItemStack dropped = stack.func_77979_a(1);
            if (stack.field_77994_a <= 0) {
                this.inventory.func_70299_a(i, null);
            }
            FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, new FakePlayerPool.PlayerUser(){

                public void usePlayer(OpenModsFakePlayer fakePlayer) {
                    fakePlayer.dropItemAt(dropped, TileEntityItemDropper.this.field_145851_c, TileEntityItemDropper.this.field_145848_d, TileEntityItemDropper.this.field_145849_e, ForgeDirection.DOWN);
                }
            });
            break;
        }
    }

    public void onNeighbourChanged(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.setRedstoneSignal(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerItemDropper((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiItemDropper(new ContainerItemDropper((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public boolean canUpdate() {
        return false;
    }
}

