/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.MapColor;
import openblocks.common.HeightMapData;
import openblocks.common.tileentity.TileEntityProjector;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.adapter.method.IMultiReturn;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.architecture.FeatureGroup;
import openperipheral.api.helpers.MultiReturn;
import org.apache.commons.lang3.ArrayUtils;

@FeatureGroup(value={"openblocks-projector"})
public class AdapterProjector
implements IPeripheralAdapter {
    public String getSourceId() {
        return "openblocks_projector";
    }

    private static int toInt(Object object) {
        return ((Number)object).intValue();
    }

    public Class<?> getTargetClass() {
        return TileEntityProjector.class;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get current map id")
    public Integer getMapId(TileEntityProjector projector) {
        int mapId = projector.mapId();
        return mapId >= 0 ? Integer.valueOf(mapId) : null;
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get current map info")
    public Map<String, Object> getMapInfo(TileEntityProjector projector) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        HashMap result = Maps.newHashMap();
        result.put("center_x", data.centerX);
        result.put("center_z", data.centerZ);
        result.put("scale", data.scale);
        result.put("dimension", data.dimension);
        HashMap layers = Maps.newHashMap();
        for (int i = 0; i < data.layers.length; ++i) {
            HeightMapData.LayerData layerData = data.layers[i];
            layers.put(i, UnsignedBytes.toInt((byte)layerData.alpha));
        }
        result.put("layers", layers);
        return result;
    }

    @ScriptCallable(description="Set current map info")
    public void setMapInfo(TileEntityProjector projector, @Arg(name="properties", description="Map of properties", type=ArgType.TABLE) Map<String, Object> args) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((data != null && data.isValid() ? 1 : 0) != 0, (Object)"Map not loaded");
        Object value = args.get("center_x");
        if (value != null) {
            data.centerX = AdapterProjector.toInt(value);
        }
        if ((value = args.get("center_z")) != null) {
            data.centerZ = AdapterProjector.toInt(value);
        }
        if ((value = args.get("dimension")) != null) {
            data.dimension = AdapterProjector.toInt(value);
        }
        if ((value = args.get("layers")) != null) {
            Map layers = (Map)value;
            for (Map.Entry e : layers.entrySet()) {
                int index = AdapterProjector.toInt(e.getKey());
                Preconditions.checkElementIndex((int)index, (int)data.layers.length, (String)"layer index");
                HeightMapData.LayerData layerData = data.layers[index];
                layerData.alpha = (byte)AdapterProjector.toInt(e.getValue());
            }
        }
        projector.markMapDirty();
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get displayed map rotation")
    public int getRotation(TileEntityProjector projector) {
        return projector.rotation();
    }

    @ScriptCallable(description="Rotate displayed map rotation")
    public void rotate(TileEntityProjector projector, @Arg(name="delta", description="Rotation delta (positive - CW, negative - CCW)") int delta) {
        projector.rotate(delta);
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.NUMBER, ReturnType.NUMBER}, description="Get height and color of point on map")
    public IMultiReturn getPoint(TileEntityProjector projector, @Arg(name="row", description="Map row (0..63)") int row, @Arg(name="column", description="Map column (0..63)") int column, @Arg(name="layer", description="Map layer") int layer) {
        Preconditions.checkElementIndex((int)row, (int)64, (String)"row");
        Preconditions.checkElementIndex((int)column, (int)64, (String)"column");
        HeightMapData data = projector.getMap();
        Preconditions.checkState((data != null && data.isValid() ? 1 : 0) != 0, (Object)"Map not loaded");
        Preconditions.checkElementIndex((int)layer, (int)data.layers.length, (String)"layer");
        int index = 64 * row + column;
        HeightMapData.LayerData layerData = data.layers[layer];
        return MultiReturn.wrap((Object[])new Object[]{UnsignedBytes.toInt((byte)layerData.heightMap[index]), layerData.colorMap[index]});
    }

    @Asynchronous
    @ScriptCallable(description="Get height and color of point on map")
    public void setPoint(TileEntityProjector projector, @Arg(name="row", description="Map row (0..63)") int row, @Arg(name="column", description="Map column (0..63)") int column, @Arg(name="layer", description="Map layer") int layer, @Arg(name="height", description="Point height") int height, @Arg(name="color", description="Point color ") int color) {
        Preconditions.checkElementIndex((int)row, (int)64, (String)"row");
        Preconditions.checkElementIndex((int)column, (int)64, (String)"column");
        Preconditions.checkElementIndex((int)height, (int)256, (String)"height");
        Preconditions.checkElementIndex((int)color, (int)MapColor.field_76281_a.length, (String)"color");
        HeightMapData data = projector.getMap();
        Preconditions.checkState((data != null && data.isValid() ? 1 : 0) != 0, (Object)"Map not loaded");
        Preconditions.checkElementIndex((int)layer, (int)data.layers.length, (String)"layer");
        int index = 64 * row + column;
        HeightMapData.LayerData layerData = data.layers[layer];
        layerData.heightMap[index] = (byte)height;
        layerData.colorMap[index] = (byte)color;
        projector.markMapDirty();
    }

    @ScriptCallable(description="Clear map")
    public void clearMap(TileEntityProjector projector) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        data.layers = new HeightMapData.LayerData[0];
        projector.markMapDirty();
    }

    @ScriptCallable(description="Clear single layer")
    public void clearLayer(TileEntityProjector projector, @Arg(name="layer", description="Map layer") int layer) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        Preconditions.checkElementIndex((int)layer, (int)data.layers.length, (String)"layer");
        HeightMapData.LayerData newLayer = new HeightMapData.LayerData();
        newLayer.alpha = (byte)-1;
        data.layers[layer] = newLayer;
        projector.markMapDirty();
    }

    @ScriptCallable(description="Append layer")
    public void appendLayer(TileEntityProjector projector) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        HeightMapData.LayerData newLayer = new HeightMapData.LayerData();
        newLayer.alpha = (byte)-1;
        data.layers = (HeightMapData.LayerData[])ArrayUtils.add((Object[])data.layers, (Object)newLayer);
        projector.markMapDirty();
    }
}

